% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasummary_skim.R
\name{datasummary_skim}
\alias{datasummary_skim}
\title{Quick overview of numeric or categorical variables}
\usage{
datasummary_skim(
  data,
  type = "numeric",
  output = "default",
  fmt = "\%.1f",
  histogram = TRUE,
  title = NULL,
  notes = NULL,
  align = NULL,
  ...
)
}
\arguments{
\item{data}{A data.frame (or tibble)}

\item{type}{of variables to summarize: "numeric" or "categorical" (character)}

\item{output}{filename or object type (character string)
\itemize{
  \item Supported filename extensions: .html, .tex, .md, .txt, .png, .jpg.
  \item Supported object types: "default", "html", "markdown", "latex", "latex_tabular", "data.frame", "gt", "kableExtra", "huxtable", "flextable".
  \item Warning: the `output` argument \emph{cannot} be used when customizing tables with external packages. See the 'Details' section below.
}}

\item{fmt}{determines how to format numeric values
\itemize{
  \item integer: the number of digits to keep after the period `format(round(x, fmt), nsmall=fmt)`
  \item character: passed to the `sprintf` function (e.g., '\%.3f' keeps 3 digits with trailing zero). See `?sprintf`
  \item function: returns a formatted character string.
}}

\item{histogram}{include a histogram (TRUE/FALSE). Supported for:
\itemize{
\item type = "numeric"
\item output is "html", "default", "jpg", "png", or "kableExtra"
\item PDF and HTML documents compiled via Rmarkdown or knitr
\item See the examples section below for an example of how to use
`datasummary` to include histograms in other formats such as markdown.
}}

\item{title}{string}

\item{notes}{list or vector of notes to append to the bottom of the table.}

\item{align}{A character string of length equal to the number of columns in
the table.  "lcr" means that the first column will be left-aligned, the 2nd
column center-aligned, and the 3rd column right-aligned.}

\item{...}{all other arguments are passed through to the extractor and
table-making functions. This allows users to specify additional options such
as set `broom::tidy(exponentiate=TRUE)` to exponentiate logistic regression
coefficients or `kableExtra::kbl(escape=FALSE)` to avoid escaping math
characters in `kableExtra` tables.}
}
\description{
This function was inspired by the excellent `skimr` package for R.
}
\examples{

\dontrun{
dat <- mtcars
dat$vs <- as.logical(dat$vs)
dat$cyl <- as.factor(dat$vs)
datasummary_skim(dat)
datasummary_skim(dat, "categorical")

# You can use `datasummary` to produce a similar table in different formats.
# Note that the `Histogram` function relies on unicode characters. These
# characters will only display correctly in some operating systems, under some
# locales, using some fonts. Displaying such histograms on Windows computers
# is notoriously tricky. The `modelsummary` authors cannot provide support to
# display these unicode histograms.

f <- All(mtcars) ~ Mean + SD + Min + Median + Max + Histogram
datasummary(f, mtcars, output="markdown")

}
}
