% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modeltime-accuracy.R
\name{metric_tweak}
\alias{metric_tweak}
\title{Modify Yardstick Metric Functions}
\usage{
metric_tweak(.f, ...)
}
\arguments{
\item{.f}{A yardstick function (e.g. \code{mase})}

\item{...}{Parameters to overload (.e.g. \code{m = 1})}
}
\description{
Used to modify functions like \code{mase()}, which have parameters that
need to be adjusted (e.g. \code{m = 1}) based on the seasonality of the data.
}
\examples{
library(modeltime)
library(yardstick)
library(tibble)
library(purrr)

fake_data <- tibble(
    y    = c(1:12, 2*1:12),
    yhat = c(1 + 1:12, 2*1:12 - 1)
)

my_metric_set <- default_forecast_accuracy_metric_set(
    metric_tweak(mase, m = 12)
)
my_metric_set

my_metric_set(fake_data, y, yhat)



}
