% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parsnip-adam.R
\name{adam_reg}
\alias{adam_reg}
\title{General Interface for ADAM Regression Models}
\usage{
adam_reg(
  mode = "regression",
  ets_model = NULL,
  non_seasonal_ar = NULL,
  non_seasonal_differences = NULL,
  non_seasonal_ma = NULL,
  seasonal_ar = NULL,
  seasonal_differences = NULL,
  seasonal_ma = NULL,
  use_constant = NULL,
  regressors_treatment = NULL,
  outliers_treatment = NULL,
  outliers_ci = NULL,
  probability_model = NULL,
  distribution = NULL,
  loss = NULL,
  information_criteria = NULL,
  seasonal_period = NULL,
  select_order = NULL
)
}
\arguments{
\item{mode}{A single character string for the type of model.
The only possible value for this model is "regression".}

\item{ets_model}{The type of ETS model. The first letter stands for the type of the error term ("A" or "M"),
the second (and sometimes the third as well) is for the trend ("N", "A", "Ad", "M" or "Md"), and the last one is
for the type of seasonality ("N", "A" or "M").}

\item{non_seasonal_ar}{The order of the non-seasonal auto-regressive (AR) terms. Often denoted "p" in pdq-notation.}

\item{non_seasonal_differences}{The order of integration for non-seasonal differencing. Often denoted "d" in pdq-notation.}

\item{non_seasonal_ma}{The order of the non-seasonal moving average (MA) terms. Often denoted "q" in pdq-notation.}

\item{seasonal_ar}{The order of the seasonal auto-regressive (SAR) terms. Often denoted "P" in PDQ-notation.}

\item{seasonal_differences}{The order of integration for seasonal differencing. Often denoted "D" in PDQ-notation.}

\item{seasonal_ma}{The order of the seasonal moving average (SMA) terms. Often denoted "Q" in PDQ-notation.}

\item{use_constant}{Logical, determining, whether the constant is needed in the model or not. This is mainly needed for
ARIMA part of the model, but can be used for ETS as well.}

\item{regressors_treatment}{The variable defines what to do with the provided explanatory variables: "use" means that all
of the data should be used, while "select" means that a selection using ic should be done, "adapt" will trigger the
mechanism of time varying parameters for the explanatory variables.}

\item{outliers_treatment}{Defines what to do with outliers: "ignore", so just returning the model, "detect" outliers based
on specified level and include dummies for them in the model, or detect and "select" those of them that reduce ic value.}

\item{outliers_ci}{What confidence level to use for detection of outliers. Default is 99\%.}

\item{probability_model}{The type of model used in probability estimation. Can be "none" - none, "fixed" - constant
probability, "general" - the general Beta model with two parameters, "odds-ratio" - the Odds-ratio model with b=1 in
Beta distribution, "inverse-odds-ratio" - the model with a=1 in Beta distribution, "direct" - the TSB-like
(Teunter et al., 2011) probability update mechanism a+b=1, "auto" - the automatically selected type of occurrence model.}

\item{distribution}{what density function to assume for the error term. The full name of the distribution should be
provided, starting with the letter "d" - "density".}

\item{loss}{The type of Loss Function used in optimization.}

\item{information_criteria}{The information criterion to use in the model selection / combination procedure.}

\item{seasonal_period}{A seasonal frequency. Uses "auto" by default.
A character phrase of "auto" or time-based phrase of "2 weeks"
can be used if a date or date-time variable is provided.
See Fit Details below.}

\item{select_order}{If TRUE, then the function will select the most appropriate order. The values list(ar=...,i=...,ma=...)
specify the maximum orders to check in this case.}
}
\description{
\code{adam_reg()} is a way to generate a \emph{specification} of an ADAM model
before fitting and allows the model to be created using
different packages. Currently the only package is \code{smooth}.
}
\details{
The data given to the function are not saved and are only used
to determine the \emph{mode} of the model. For \code{adam_reg()}, the
mode will always be "regression".

The model can be created using the \code{fit()} function using the
following \emph{engines}:
\itemize{
\item "auto_adam" (default) - Connects to \code{\link[smooth:adam]{smooth::auto.adam()}}
\item "adam" - Connects to \code{\link[smooth:adam]{smooth::adam()}}
}

\strong{Main Arguments}

The main arguments (tuning parameters) for the model are:
\itemize{
\item \code{seasonal_period}: The periodic nature of the seasonality. Uses "auto" by default.
\item \code{non_seasonal_ar}: The order of the non-seasonal auto-regressive (AR) terms.
\item \code{non_seasonal_differences}: The order of integration for non-seasonal differencing.
\item \code{non_seasonal_ma}: The order of the non-seasonal moving average (MA) terms.
\item \code{seasonal_ar}: The order of the seasonal auto-regressive (SAR) terms.
\item \code{seasonal_differences}: The order of integration for seasonal differencing.
\item \code{seasonal_ma}: The order of the seasonal moving average (SMA) terms.
\item \code{ets_model}: The type of ETS model.
\item \code{use_constant}: Logical, determining, whether the constant is needed in the model or not.
\item \code{regressors_treatment}: The variable defines what to do with the provided explanatory variables.
\item \code{outliers_treatment}: Defines what to do with outliers.
\item \code{probability_model}: The type of model used in probability estimation.
\item \code{distribution}: what density function to assume for the error term.
\item \code{loss}: The type of Loss Function used in optimization.
\item \code{information_criteria}: The information criterion to use in the model selection / combination procedure.
}

These arguments are converted to their specific names at the
time that the model is fit.

Other options and argument can be
set using \code{set_engine()} (See Engine Details below).

If parameters need to be modified, \code{update()} can be used
in lieu of recreating the object from scratch.

\strong{auto_adam (default engine)}

The engine uses \code{\link[smooth:adam]{smooth::auto.adam()}}.

Function Parameters:

\if{html}{\out{<div class="sourceCode">}}\preformatted{#> Registered S3 method overwritten by 'greybox':
#>   method     from
#>   print.pcor lava
#> function (data, model = "ZXZ", lags = c(frequency(data)), orders = list(ar = c(0), 
#>     i = c(0), ma = c(0), select = FALSE), formula = NULL, regressors = c("use", 
#>     "select", "adapt"), occurrence = c("none", "auto", "fixed", "general", 
#>     "odds-ratio", "inverse-odds-ratio", "direct"), distribution = c("dnorm", 
#>     "dlaplace", "ds", "dgnorm", "dlnorm", "dinvgauss", "dgamma"), outliers = c("ignore", 
#>     "use", "select"), level = 0.99, h = 0, holdout = FALSE, persistence = NULL, 
#>     phi = NULL, initial = c("optimal", "backcasting", "complete"), arma = NULL, 
#>     ic = c("AICc", "AIC", "BIC", "BICc"), bounds = c("usual", "admissible", 
#>         "none"), silent = TRUE, parallel = FALSE, ...)
}\if{html}{\out{</div>}}

The \emph{MAXIMUM} nonseasonal ARIMA terms (\code{max.p}, \code{max.d}, \code{max.q}) and
seasonal ARIMA terms (\code{max.P}, \code{max.D}, \code{max.Q}) are provided to
\code{\link[forecast:auto.arima]{forecast::auto.arima()}} via \code{arima_reg()} parameters.
Other options and argument can be set using \code{set_engine()}.

Parameter Notes:
\itemize{
\item All values of nonseasonal pdq and seasonal PDQ are maximums.
The \code{smooth::auto.adam()} model will select a value using these as an upper limit.
\item \code{xreg} - This is supplied via the parsnip / modeltime \code{fit()} interface
(so don't provide this manually). See Fit Details (below).
}

\strong{adam}

The engine uses \code{\link[smooth:adam]{smooth::adam()}}.

Function Parameters:

\if{html}{\out{<div class="sourceCode">}}\preformatted{#> function (data, model = "ZXZ", lags = c(frequency(data)), orders = list(ar = c(0), 
#>     i = c(0), ma = c(0), select = FALSE), constant = FALSE, formula = NULL, 
#>     regressors = c("use", "select", "adapt"), occurrence = c("none", "auto", 
#>         "fixed", "general", "odds-ratio", "inverse-odds-ratio", "direct"), 
#>     distribution = c("default", "dnorm", "dlaplace", "ds", "dgnorm", "dlnorm", 
#>         "dinvgauss", "dgamma"), loss = c("likelihood", "MSE", "MAE", "HAM", 
#>         "LASSO", "RIDGE", "MSEh", "TMSE", "GTMSE", "MSCE"), outliers = c("ignore", 
#>         "use", "select"), level = 0.99, h = 0, holdout = FALSE, persistence = NULL, 
#>     phi = NULL, initial = c("optimal", "backcasting", "complete"), arma = NULL, 
#>     ic = c("AICc", "AIC", "BIC", "BICc"), bounds = c("usual", "admissible", 
#>         "none"), silent = TRUE, ...)
}\if{html}{\out{</div>}}

The nonseasonal ARIMA terms (\code{orders}) and seasonal ARIMA terms (\code{orders})
are provided to \code{\link[smooth:adam]{smooth::adam()}} via \code{adam_reg()} parameters.
Other options and argument can be set using \code{set_engine()}.

Parameter Notes:
\itemize{
\item \code{xreg} - This is supplied via the parsnip / modeltime \code{fit()} interface
(so don't provide this manually). See Fit Details (below).
}
}
\section{Fit Details}{


\strong{Date and Date-Time Variable}

It's a requirement to have a date or date-time variable as a predictor.
The \code{fit()} interface accepts date and date-time features and handles them internally.
\itemize{
\item \code{fit(y ~ date)}
}

\emph{Seasonal Period Specification}

The period can be non-seasonal (\verb{seasonal_period = 1 or "none"}) or
yearly seasonal (e.g. For monthly time stamps, \code{seasonal_period = 12}, \code{seasonal_period = "12 months"}, or \code{seasonal_period = "yearly"}).
There are 3 ways to specify:
\enumerate{
\item \code{seasonal_period = "auto"}: A seasonal period is selected based on the periodicity of the data (e.g. 12 if monthly)
\item \code{seasonal_period = 12}: A numeric frequency. For example, 12 is common for monthly data
\item \code{seasonal_period = "1 year"}: A time-based phrase. For example, "1 year" would convert to 12 for monthly data.
}

\strong{Univariate (No xregs, Exogenous Regressors):}

For univariate analysis, you must include a date or date-time feature. Simply use:
\itemize{
\item Formula Interface (recommended): \code{fit(y ~ date)} will ignore xreg's.
}

\strong{Multivariate (xregs, Exogenous Regressors)}

The \code{xreg} parameter is populated using the \code{fit()} function:
\itemize{
\item Only \code{factor}, \verb{ordered factor}, and \code{numeric} data will be used as xregs.
\item Date and Date-time variables are not used as xregs
\item \code{character} data should be converted to factor.
}

\emph{Xreg Example:} Suppose you have 3 features:
\enumerate{
\item \code{y} (target)
\item \code{date} (time stamp),
\item \code{month.lbl} (labeled month as a ordered factor).
}

The \code{month.lbl} is an exogenous regressor that can be passed to the \code{arima_reg()} using
\code{fit()}:
\itemize{
\item \code{fit(y ~ date + month.lbl)} will pass \code{month.lbl} on as an exogenous regressor.
}

Note that date or date-time class values are excluded from \code{xreg}.
}

\examples{
\donttest{
library(dplyr)
library(parsnip)
library(rsample)
library(timetk)
library(modeltime)
library(smooth)

# Data
m750 <- m4_monthly \%>\% filter(id == "M750")
m750

# Split Data 80/20
splits <- initial_time_split(m750, prop = 0.8)

# ---- AUTO ADAM ----

# Model Spec
model_spec <- adam_reg() \%>\%
    set_engine("auto_adam")

# Fit Spec
model_fit <- model_spec \%>\%
    fit(log(value) ~ date, data = training(splits))
model_fit


# ---- STANDARD ADAM ----

# Model Spec
model_spec <- adam_reg(
        seasonal_period          = 12,
        non_seasonal_ar          = 3,
        non_seasonal_differences = 1,
        non_seasonal_ma          = 3,
        seasonal_ar              = 1,
        seasonal_differences     = 0,
        seasonal_ma              = 1
    ) \%>\%
    set_engine("adam")

# Fit Spec
model_fit <- model_spec \%>\%
    fit(log(value) ~ date, data = training(splits))
model_fit
}

}
\seealso{
\code{\link[=fit.model_spec]{fit.model_spec()}}, \code{\link[=set_engine]{set_engine()}}
}
