% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_correlation.R
\name{get_correlation}
\alias{get_correlation}
\title{Get correlation value in a tidy way}
\usage{
get_correlation(data, formula, na.rm = FALSE, ...)
}
\arguments{
\item{data}{a data frame object}

\item{formula}{a formula with the response variable name on the left and 
the explanatory variable name on the right}

\item{na.rm}{a logical value indicating whether NA values should be stripped 
before the computation proceeds.}

\item{...}{further arguments passed to \code{\link[stats]{cor}}}
}
\value{
A 1x1 data frame storing the correlation value
}
\description{
Determine the Pearson correlation coefficient between two variables in
a data frame using pipeable and formula-friendly syntax
}
\examples{
library(moderndive)

# Compute correlation between mpg and cyl:
mtcars \%>\% 
   get_correlation(formula = mpg ~ cyl)
   
# Group by one variable:
library(dplyr)
mtcars \%>\% 
  group_by(am) \%>\% 
  get_correlation(formula = mpg ~ cyl)
  
# Group by two variables:
mtcars \%>\% 
  group_by(am, gear) \%>\% 
  get_correlation(formula = mpg ~ cyl)
}
