% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{coffee_ratings}
\alias{coffee_ratings}
\title{Data from the Coffee Quality Institute's review pages in January 2018}
\format{
A data frame of 1,340 rows representing each sample of coffee.
\describe{
\item{total_cup_points}{Number of points in final rating (scale of 0-100)}
\item{species}{Species of coffee bean plant (Arabica or Robusta)}
\item{owner}{Owner of coffee plant farm}
\item{country_of_origin}{Coffee bean's country of origin}
\item{farm_name}{Name of coffee plant farm}
\item{lot_number}{Lot number for tested coffee beans}
\item{mill}{Name of coffee bean's processing facility}
\item{ico_number}{International Coffee Organization number}
\item{company}{Name of coffee bean's company}
\item{altitude}{Altitude at which coffee plants were grown}
\item{region}{Region where coffee plants were grown}
\item{producer}{Name of coffee bean roaster}
\item{number_of_bags}{Number of tested bags}
\item{bag_weight}{Tested bag weight}
\item{in_country_partner}{Partner for the country}
\item{harvest_year}{Year the coffee beans were harvested}
\item{grading_date}{Day the coffee beans were graded}
\item{owner_1}{Owner of the coffee beans}
\item{variety}{Variety of the coffee beans}
\item{processing_method}{Method used for processing the coffee beans}
\item{aroma}{Coffee aroma rating}
\item{flavor}{Coffee flavor rating}
\item{aftertaste}{Coffee aftertaste rating}
\item{acidity}{Coffee acidity rating}
\item{body}{Coffee body rating}
\item{balance}{Coffee balance rating}
\item{uniformity}{Coffee uniformity rating}
\item{clean_cup}{Cup cleanliness rating}
\item{sweetness}{Coffee sweetness rating}
\item{cupper_points}{Cupper Points, an overall rating for the coffee}
\item{moisture}{Coffee moisture content}
\item{category_one_defects}{Number of category one defects for the coffee beans}
\item{quakers}{Number of coffee beans that don't dark brown when roasted}
\item{color}{Color of the coffee beans}
\item{category_two_defects}{Number of category two defects for the coffee beans}
\item{expiration}{Expiration date of the coffee beans}
\item{certification_body}{Entity/Institute that certified the coffee beans}
\item{certification_address}{Body address of certification for coffee beans}
\item{certification_contact}{Certification contact for coffee beans}
\item{unit_of_measurement}{Unit of measurement for altitude}
\item{altitude_low_meters}{Lower altitude level coffee beans grow at}
\item{altitude_high_meters}{Higher altitude level coffee beans grow at}
\item{altitude_mean_meters}{Average altitude level coffee beans grow at}
}
}
\source{
Coffee Quality Institute. Access cleaned data available at \url{https://github.com/jldbc/coffee-quality-database}
}
\usage{
coffee_ratings
}
\description{
1,340 digitized reviews on coffee samples from
\url{https://database.coffeeinstitute.org/}.
}
\keyword{datasets}
