% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/code.R
\name{suggest_category}
\alias{suggest_category}
\title{Compare model performance by model category from \pkg{caret} package}
\usage{
suggest_category(addTo, modelTag = NULL)
}
\arguments{
\item{addTo}{Summary list that contains model fits to compare.}

\item{modelTag}{Select model fits containing \code{modelTag} in their name.}
}
\value{
Plots of AUC and accuracy, organized by category tags.
}
\description{
\code{suggest_category} collects AUC and accuracy results by model category
and presents average performance using the model category tags as definded
by \pkg{caret}. This helps the user identify the most promising category
of models for further exploration.
}
\examples{
\dontrun{
library(mlbench)
data(PimaIndiansDiabetes)
index <- sample(seq_len(nrow(PimaIndiansDiabetes)), 500)
trainingSet <- PimaIndiansDiabetes[index, ]
testSet <- PimaIndiansDiabetes[-index, ]
x <- trainingSet[, -9]
y <- trainingSet[, 9]
x_test <- testSet[, -9]
y_test <- testSet[, 9]
sSummary <- list()
sSummary <- add_model(sSummary, x, y)
sSummary <- add_model(sSummary, x, y, model = c("C5.0Cost", "glmnet"), modelTag = "others")

suggest_category(sSummary)

# vignette("modeval") #check a vignette for further details
}
}
