% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pwmk.R
\name{pwmk}
\alias{pwmk}
\title{Mann-Kendall Test of Pre-Whitened Time Series Data in Presence of Serial Correlation Using von Storch, H. (1995) Approach.}
\usage{
pwmk(x)
}
\arguments{
\item{x}{- Time series data vector}
}
\value{
Z-Value  - Z-Statistic after Pre-Whitening

Sen's Slope  - Sen's slope for Prewhitened series

old. Sen's Slope  - Sen's slope for Original data series 'x'

P-value  - P-Value after Pre-Whitening

S  - Mann-Kendall 'S'- statistic

Var(s) - Variance of 's'

Tau  - Mann-Kendall's Tau
}
\description{
When the time series data is not random and influenced by auto-correlation, Pre-Whitening the time series prior to application of trend test is suggested.
}
\details{
Pre-Whitening involves calculating lag-1 serial correlation coefficient and calculating new-series.
}
\examples{
x<-c(Nile)
pwmk(x)

}
\references{
Mann, H. B. (1945). Nonparametric Tests Against Trend. Econometrica, 13(3), 245–259. <doi:10.1017/CBO9781107415324.004>.

Kendall, M. (1975). Multivariate analysis. Charles Griffin. Londres. 0-85264-234-2.

von Storch, H. , Navarra, A. (1995). Misuses of Statistical Analysis in Climate Research. in Analysis of Climate Variability-Applications of Statistical Techniques:11–26. <doi:10.1007/978-3-662-03167-4>.

Kulkarni A, Storch H Von. (1995). Monte Carlo experiments on the effect of serial correlation on the Mann-Kendall test of trend. Meteorol Zeitschrift,4(JANUARY):82-85.

Yue, S., & Wang, C. Y. (2002). Applicability of prewhitening to eliminate the influence of serial correlation on the Mann-Kendall test. Water Resources Research, 38(6), 4-1-4–7. <doi:10.1029/2001WR000861>.

Salas, J.D., (1980). Applied modeling of hydrologic times series. Water Resources Publication.
}
