% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_interaction.R
\name{plot_interaction}
\alias{plot_interaction}
\title{Plot Interaction Effects}
\usage{
plot_interaction(
  x,
  z,
  y,
  xz = NULL,
  vals_x = seq(-3, 3, 0.001),
  vals_z,
  model,
  alpha_se = 0.15,
  ...
)
}
\arguments{
\item{x}{The name of the variable on the x-axis}

\item{z}{The name of the moderator variable}

\item{y}{The name of the outcome variable}

\item{xz}{The name of the interaction term. If the interaction term is not specified, it
will be created using \code{x} and \code{z}.}

\item{vals_x}{The values of the \code{x} variable to plot, the more values the smoother the std.error-area will be}

\item{vals_z}{The values of the moderator variable to plot. A separate regression
line (\code{y ~ x | z}) will be plotted for each value of the moderator variable}

\item{model}{An object of class \code{\link{modsem_pi}}, \code{\link{modsem_da}}, or \code{\link{modsem_mplus}}}

\item{alpha_se}{The alpha level for the std.error area}

\item{...}{Additional arguments passed to other functions}
}
\value{
A \code{ggplot} object
}
\description{
Plot Interaction Effects
}
\examples{
library(modsem)
\dontrun{
m1 <- "
# Outer Model
  X =~ x1
  X =~ x2 + x3
  Z =~ z1 + z2 + z3
  Y =~ y1 + y2 + y3

# Inner model
  Y ~ X + Z + X:Z
"
est1 <- modsem(m1, data = oneInt)
plot_interaction("X", "Z", "Y", "X:Z", -3:3, c(-0.2, 0), est1)

tpb <- "
# Outer Model (Based on Hagger et al., 2007)
  ATT =~ att1 + att2 + att3 + att4 + att5
  SN =~ sn1 + sn2
  PBC =~ pbc1 + pbc2 + pbc3
  INT =~ int1 + int2 + int3
  BEH =~ b1 + b2

# Inner Model (Based on Steinmetz et al., 2011)
  # Causal Relationsships
  INT ~ ATT + SN + PBC
  BEH ~ INT + PBC
  # BEH ~ ATT:PBC
  BEH ~ PBC:INT
  # BEH ~ PBC:PBC
"

est2 <- modsem(tpb, TPB, method = "lms")
plot_interaction(x = "INT", z = "PBC", y = "BEH", xz = "PBC:INT",
                 vals_z = c(-0.5, 0.5), model = est2)
}
}
