% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics_modsem_da.R
\name{standardized_estimates.modsem_da}
\alias{standardized_estimates.modsem_da}
\title{Get standardized estimates with Monte Carlo bootstrapped standard errors}
\usage{
\method{standardized_estimates}{modsem_da}(
  object,
  monte.carlo = FALSE,
  mc.reps = 10000,
  tolerance.zero = 1e-10,
  ...
)
}
\arguments{
\item{object}{An object of class \code{modsem_da}}

\item{monte.carlo}{Should standard errors be calculated using Monte Carlo simulation. 
if \code{FALSE} the delta method is used instead. Default is \code{FALSE}.}

\item{mc.reps}{Number of Monte Carlo repetitions}

\item{tolerance.zero}{Tolerance for zero values. Standard errors smaller than this 
value will be set to NA.}

\item{...}{Additional arguments passed to other functions}
}
\description{
Get standardized estimates with Monte Carlo bootstrapped standard errors
}
\details{
The interaction term is not standardized such that \code{var(xz) = 1}.
The interaction term is not an actual variable in the model, meaning that it does not
have a variance. It must therefore be calculated from the other parameters in the model.
Assuming normality and zero-means, the variance is calculated as
\code{var(xz) = var(x) * var(z) + cov(x, z)^2}. Thus setting the variance of the interaction
term to 1 would only be 'correct' if the correlation between \code{x} and \code{z} is zero.
This means that the standardized estimates for the interaction term will
be different from those using \code{lavaan}, since there the interaction term is an
actual latent variable in the model, with a standardized variance of 1.
}
