% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zipf.fit.R
\name{zipf.fit}
\alias{zipf.fit}
\title{Zipf parameter estimation.}
\usage{
zipf.fit(data, init_alpha, show.plot = FALSE, ...)
}
\arguments{
\item{data}{Matrix of count data.}

\item{init_alpha}{Initial value for the \eqn{\alpha} parameter (\eqn{\alpha > 1}).}

\item{show.plot}{logical; if TRUE shows the plot of the fitting (default = FALSE).}

\item{...}{Further arguments to pass to \link{optim}.}
}
\value{
Returns an object that contains:
 \item{alpha}{Estimated value of the \eqn{\alpha} parameter.}
 \item{mloglik}{Value of the maximum log-likelihood.}
 \item{fitted.values}{Estimated counts at given levels.}
}
\description{
Estimates the parameter of the Zipf distribution by means of the maximum likelihood
method, for a given count data set.
}
\details{
The argument \code{data} is a matrix where the first column corresponds to the count,
and the second column contains its corresponding.

The log-likelihood function is computed by means of the following equation:
\deqn{l(\alpha; x) = -\alpha \sum_x ^{m} log(x) f_{a}(x_i) - N log(\zeta(\alpha))}

where \eqn{N} is the sample size (\eqn{N = \sum_{i = 1} ^m x_i f_a(x_i)}), \eqn{m} the different values \eqn{x_{i}}, each one of them with absolute frequency equal to \eqn{f_{a}(x_i)}.

The function \emph{\link{optim}} is used to estimate the parameters.
}
\examples{
data <- rmoezipf(1000, 2.5, 1 )
data <- moezipfR.utils.getDataMatrix(data)
zipf.fit(data, 1.0001)
}

