% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optim_hego.R
\name{EHVI}
\alias{EHVI}
\title{EHVI: Constrained Expected Hypervolume Improvement}
\usage{
EHVI(x, model, control = NULL)
}
\arguments{
\item{x}{a vector representing the input for which one wishes to calculate \code{EHI}, alternatively a matrix with one point per row,}

\item{model}{An object of class \code{\link{mkm}}.}

\item{control}{An optional list of control parameters, some of them passed to
the \code{\link[GPareto]{crit_EHI}} function. One can control:
\describe{
\item{\code{minimization}}{logical indicating if the EHVI is minimizing all
objectives (\code{TRUE}, by default) or maximizing all objectives
(\code{FALSE}). Mixed optimization is not currently accepted, if the user
needs it, the cost functions should be modified prior Kriging modeling
(i.e. inverting or multiplying the output by \code{-1}).}
\item{\code{paretoFront}}{object of class \code{\link{ps}} containing the
actual Pareto set. If not provided a Pareto set is built based on the
current feasible observations (\code{model@response[model@feasible,]}).}
\item{\code{nb.samp}}{number of random samples from the posterior distribution
 (with more than two objectives), default to 50, increasing gives more reliable
  results at the cost of longer computation time}
\item{\code{seed}}{seed used for the random samples (with more than two objectives);}
\item{\code{refPoint}}{reference point for Hypervolume Expected Improvement.
 If not provided, it is set to the maximum or minimum of each objective.}
 }}
}
\value{
The constrained expected hypervolume improvement at \code{x}.
}
\description{
Multi-objective Expected Hypervolume Improvement with respect to the current
Pareto front. It's based on the \code{\link{crit_EHI}} function of the
\code{\link{GPareto-package}} package. However, the present implementation accounts
for inequality constrains embedded into the \code{mkm} model.
}
\details{
The way that the constraints are handled are based on the probability of
feasibility. The strong assumption here is that the cost functions and the
constraints are uncorrelated. With that assumption in mind, a simple
closed-form solution can be derived that consists in the product of the
probability that each constraint will be met and the expected improvement of
the objective.
}
\examples{
# ------------------------
# The Nowacki Beam
# ------------------------
n <- 10
d <- 2
doe <- replicate(d,sample(0:n,n))/n
res <- t(apply(doe, 1, nowacki_beam, box = data.frame(b = c(10, 50), h = c(50, 250))))
model <- mkm(doe, res, modelcontrol = list(objective = 1:2, lower=rep(0.1,d)))
grid <- expand.grid(seq(0, 1, , 10),seq(0, 1, , 10))
ehvi <- apply(grid, 1, EHVI, model)
contour(matrix(ehvi, 20))
points(model@design, col=ifelse(model@feasible,'blue','red'))
points(grid[which.max(ehvi),], col='green', pch=19)
}
\references{
Forrester, A., Sobester, A., & Keane, A. (2008).
  \emph{Engineering design via surrogate modeling: a practical guide.} John
  Wiley & Sons.
}
