% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RFI3d.R
\name{RFI3d}
\alias{RFI3d}
\title{Plot 3D and 2D areas of a mesh used to calculate relief index}
\usage{
RFI3d(RFI_Output, displacement = -1.9, SurfaceColor = "gray",
  FootColor = "red", FootPts = FALSE, FootPtsColor = "black",
  Opacity = 1, legend = F, legendScale = 1, leftOffset = 0,
  fieldofview = 0)
}
\arguments{
\item{RFI_Output}{An object that stores the output of the RFI
function}

\item{displacement}{Moves the surface footprint some
proportion of the height of the mesh. 0 is no
displacement. Expects a value, negative values displace
the footprint downward.}

\item{SurfaceColor}{changes the color of the 3D surface mesh}

\item{FootColor}{changes color of the 2D surface footprint}

\item{FootPts}{logical indicating whether to plot the
flattened points of the footprint from the original ply file}

\item{FootPtsColor}{color for the plotted footprint points}

\item{Opacity}{adjusts the opacity of the 3D mesh
surface}

\item{legend}{Logical indicating whether or not to include a
legend of the colors chosen to represent the 3D surface and
footprint}

\item{legendScale}{cex style numeric relative scaling factor for the legend}

\item{leftOffset}{how numeric between -1 and 1 for which to offset the surface
relative to the legend.}

\item{fieldofview}{Passes an argument to par3d changing the
field of view in degrees of the resulting rgl window.}
}
\description{
A function that plots a three-dimensional model of the mesh
surface and includes a footprint of the two-dimensional area for
visual comparison.
}
\details{
This function can help to visualize the three-dimensional and two
dimensional areas that are used in calculating the relief index of a surface by
displaying both at the same time. The RFI function must be performed first.

Opacity can be adjusted in a range from fully opaque (1) to fully
transparent (0) in order to help visualize the footprint. The vertical placement of
the footprint along the Z axis can be altered with displace depending on how the
user wishes to view the surface, or on the original mesh orientation.

fieldofview is set to a default of 0, which is an isometric projection. Increasing it
alters the degree of parallax in the perspective view, up to a maximum of 179
degrees.
}
\examples{
RFI_output <- RFI(ex_tooth1)
RFI3d(RFI_output)
}
