% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crawlWrap.R
\name{crawlWrap}
\alias{crawlWrap}
\title{Fit and predict tracks for using crawl}
\usage{
crawlWrap(obsData, timeStep = 1, ncores, retryFits = 0, mov.model = ~1,
  err.model = NULL, activity = NULL, drift = NULL, coord = c("x", "y"),
  Time.name = "time", initial.state, theta, fixPar, method = "L-BFGS-B",
  control = NULL, constr = NULL, prior = NULL, need.hess = TRUE,
  initialSANN = list(maxit = 200), attempts = 1, predTime = NULL,
  fillCols = FALSE)
}
\arguments{
\item{obsData}{data.frame object containing fields for animal ID ('ID'), time of observation (identified by \code{Time.name}, must be numeric or POSIXct), 
and observed locations (x- and y- coordinates identified by \code{coord}), such as that returned by \code{\link{simData}} when temporally-irregular observed locations or
measurement error are included. Alternatively, a 'SpatialPointsDataFrame' object from the package 'sp' will 
also be accepted, in which case the \code{coord} values will be taken from the spatial data set and ignored in the arguments.  
Note that \code{\link[crawl]{crwMLE}} requires that longitude/latitude coordinates be projected to UTM (i.e., easting/northing). For further details see \code{\link[crawl]{crwMLE}}.}

\item{timeStep}{Length of the time step at which to predict regular locations from the fitted model. Unless \code{predTime} is specified, the sequence of times
is \code{seq(a_i,b_i,timeStep)} where a_i and b_i are the times of the first and last observations for individual i. \code{timeStep} can be numeric (regardless of
whether \code{obsData[[Time.name]]} is numeric or POSIXct) or a character string (if \code{obsData[[Time.name]]} is of class POSIXct) containing one of "sec", "min", "hour", "day", "DSTday", "week", "month", "quarter" or "year". 
This can optionally be preceded by a positive integer and a space, or followed by "s" (e.g., ``2 hours''; see \code{\link[base]{seq.POSIXt}}). \code{timeStep} is not used for individuals for which \code{predTime} is specified.}

\item{ncores}{Number of cores to use for parallel processing.}

\item{retryFits}{Number of times to attempt to achieve convergence and valid (i.e., not NaN) variance estimates after the initial model fit. \code{retryFits} differs
from \code{attempts} because \code{retryFits} iteratively uses random perturbations of the current parameter estimates as the initial values for likelihood optimization, while 
\code{attempts} uses the same initial values (\code{theta}) for each attempt.}

\item{mov.model}{List of mov.model objects (see \code{\link[crawl]{crwMLE}}) containing an element for each individual. If only one movement model is provided, then the same movement model is used
for each individual.}

\item{err.model}{List of err.model objects (see \code{\link[crawl]{crwMLE}}) containing an element for each individual. If only one error model is provided, then the same error model is used
for each individual (in which case the names of the \code{err.model} components corresponding to easting/longitudinal and northing/latitudinal location error must match \code{coord}).}

\item{activity}{List of activity objects (see \code{\link[crawl]{crwMLE}}) containing an element for each individual. If only one activity covariate is provided, then the same activity covariate is used
for each individual.}

\item{drift}{List of drift objects (see \code{\link[crawl]{crwMLE}}) containing an element for each individual. If only one drift component is provided, then the same drift component is used
for each individual.}

\item{coord}{A 2-vector of character values giving the names of the "x" and
"y" coordinates in \code{data}. See \code{\link[crawl]{crwMLE}}.}

\item{Time.name}{Character indicating name of the location time column.  See \code{\link[crawl]{crwMLE}}.}

\item{initial.state}{List of initial.state objects (see \code{\link[crawl]{crwMLE}}) containing an element for each individual. If only one initial state is provided, then the same initial states are used
for each individual.}

\item{theta}{List of theta objects (see \code{\link[crawl]{crwMLE}}) containing an element for each individual. If only one theta is provided, then the same starting values are used
for each individual.}

\item{fixPar}{List of fixPar objects (see \code{\link[crawl]{crwMLE}}) containing an element for each individual. If only one fixPar is provided, then the same parameters are held fixed to the given value
for each individual.}

\item{method}{Optimization method that is passed to \code{\link{optim}}.}

\item{control}{Control list which is passed to \code{\link{optim}}.}

\item{constr}{List of constr objects (see \code{\link[crawl]{crwMLE}}) containing an element for each individual. If only one constr is provided, then the same box constraints for the parameters are used
for each individual.}

\item{prior}{List of prior objects (see \code{\link[crawl]{crwMLE}}) containing an element for each individual. If only one prior is provided, then the same prior is used
for each individual.}

\item{need.hess}{A logical value which decides whether or not to evaluate
the Hessian for parameter standard errors}

\item{initialSANN}{Control list for \code{\link{optim}} when simulated
annealing is used for obtaining start values. See details}

\item{attempts}{The number of times likelihood optimization will be
attempted using \code{theta} as the starting values.  Note this is not the same as \code{retryFits}.}

\item{predTime}{List of predTime objects (see \code{\link[crawl]{crwPredict}}) containing an element for each individual. \code{predTime} can 
be specified as an alternative to the automatic sequences generated according to \code{timeStep}.  If only one predTime object is provided, then the same prediction times are used
for each individual.}

\item{fillCols}{Logical indicating whether or not to use the crawl::\code{\link[crawl]{fillCols}} function for filling in missing values in \code{obsData} for which
there is a single unique value. Default: FALSE. If the output from \code{crawlWrap} is intended for analyses using \code{\link{fitHMM}} or \code{\link{MIfitHMM}}, 
setting \code{fillCols=TRUE} should typically be avoided.}
}
\value{
A \code{\link{crwData}} object, i.e. a list of:
\item{crwFits}{A list of \code{crwFit} objects returned by crawl::crwMLE. See \code{\link[crawl]{crwMLE}}}
\item{crwPredict}{A \code{crwPredict} data frame with \code{obsData} merged with the predicted locations. See \code{\link[crawl]{crwPredict}}.}
The \code{\link{crwData}} object is used in \code{\link{MIfitHMM}} analyses that account for temporal irregularity or location measurement error.
}
\description{
Wrapper function for fitting crawl::crwMLE models and predicting locations with crawl::crwPredict for multiple individuals.
}
\details{
\itemize{
\item Consult \code{\link[crawl]{crwMLE}} and \code{\link[crawl]{crwPredict}} for futher details about model fitting and prediction. 

\item Note that the names of the list elements corresponding to each individual in \code{mov.model}, \code{err.model}, \code{activity}, \code{drift}, \code{initial.state},
\code{theta}, \code{fixPar}, \code{constr}, \code{prior}, and \code{predTime} must match the individual IDs in \code{obsData}.  If only one element is provided
for any of these arguments, then the same element will be applied to all individuals.
}
}
\examples{
\dontrun{
# extract simulated obsData from example data
obsData <- miExample$obsData

# extract crwMLE inputs from example data
inits <- miExample$inits # initial state
err.model <- miExample$err.model # error ellipse model

# Fit crwMLE models to obsData and predict locations 
# at default intervals for both individuals
crwOut1 <- crawlWrap(obsData=obsData,ncores=1,
         theta=c(4,0),fixPar=c(1,1,NA,NA),
         initial.state=inits,
         err.model=err.model,attempts=100)

# Fit the same crwMLE models and predict locations 
# at same intervals but specify for each individual using lists
crwOut2 <- crawlWrap(obsData=obsData,ncores=1,
         theta=list(c(4,0),c(4,0)), fixPar=list(c(1,1,NA,NA),c(1,1,NA,NA)),
         initial.state=list(inits,inits),
         err.model=list(err.model,err.model),
         predTime=list('1'=seq(1,633),'2'=seq(1,686)))
}

}
\seealso{
\code{\link{MIfitHMM}}, \code{\link{simData}}
}
