% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_utils.R
\name{plot_tree}
\alias{plot_tree}
\title{Plot the monoClust Tree.}
\usage{
plot_tree(
  x,
  uniform = FALSE,
  branch = 1,
  margin = 0,
  minbranch = 0.3,
  rel.loc.x = TRUE,
  ...
)
}
\arguments{
\item{x}{MonoClust result object.}

\item{uniform}{If TRUE, uniform vertical spacing of the nodes is used; this
may be less cluttered when fitting a large plot onto a page. The default is
to use a non-uniform spacing proportional to the inertia in the fit.}

\item{branch}{Controls the shape of the branches from parent to child node.
Any number from 0 to 1 is allowed. A value of 1 gives square shouldered
branches, a value of 0 give V shaped branches, with other values being
intermediate.}

\item{margin}{An extra fraction of white space to leave around the borders of
the tree. (Long labels sometimes get cut off by the default computation).}

\item{minbranch}{Set the minimum length for a branch to \code{minbranch} times the
average branch length. This parameter is ignored if \code{uniform = TRUE}.
Sometimes a split will give very little improvement, or even no improvement
at all. A tree with branch lengths strictly proportional to improvement
leaves no room to squeeze in node labels.}

\item{rel.loc.x}{Whether to use the relative distance between clusters as x
coordinate of the leaves. Default is TRUE.}

\item{...}{Arguments to be passed to \code{\link[graphics:plot.default]{graphics::plot.default()}} and
\code{\link[graphics:lines]{graphics::lines()}}}
}
\value{
Plot of tree
}
\description{
This function plots the MonoClust tree. It is partially inspired by rpart
package.
}
\keyword{internal}
