% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MonoClust.R
\name{checkem}
\alias{checkem}
\title{First Gate Function}
\usage{
checkem(
  data,
  cuts,
  frame,
  cloc,
  dist,
  variables,
  minsplit,
  minbucket,
  split_order,
  ncores
)
}
\arguments{
\item{data}{Original data set.}

\item{cuts}{Cuts data set, which has the next higher value of each variable
in the original data set.}

\item{frame}{The split tree transferred as data frame.}

\item{cloc}{Vector of current cluster membership.}

\item{dist}{Distance matrix of all observations in the data.
exported function yet. Vector of 1 for all observations.}

\item{variables}{List of variables selected for clustering procedure. It
could be a vector of variable indexes, or a vector of variable names.}

\item{minsplit}{The minimum number of observations that must exist in a node
in order for a split to be attempted.}

\item{minbucket}{The minimum number of observations in any terminal leaf
node. Default is \code{minsplit/3}.}

\item{split_order}{The control argument to see how many split has been done.}

\item{ncores}{Number of CPU cores on the current host.}
}
\value{
It is not supposed to return anything because global environment was
used. However, if there is nothing left to split, it returns 0 to tell the
caller to stop running the loop.
}
\description{
This function checks what are available nodes to split and then call
\code{find_split()} on each node, then decide which node creates best split, and
call \code{splitter()} to perform the split.
}
\keyword{internal}
