% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/99_DESC_STAT.R
\name{desc.stat}
\alias{desc.stat}
\title{Descriptive statistics}
\usage{
desc.stat(x, y, sc = c(NA, NaN, Inf), sc.method = "together")
}
\arguments{
\item{x}{Numeric risk factor.}

\item{y}{Numeric target vector (binary or continuous).}

\item{sc}{Numeric vector with special case elements. Default values are c(NA, NaN, Inf).
Recommendation is to keep the default values always and add new ones if needed.
Otherwise, if these values exist in x and are not defined in the sc vector, function will report the error.}

\item{sc.method}{Define how special cases will be treated, all together or in separate bins.
Possible values are \code{"together", "separately"}.}
}
\value{
Data frame of descriptive statistics metrics, separately for complete and special case groups.
}
\description{
\code{desc.stat} returns the descriptive statistics of numeric risk factor. Reported metrics covers mainly
univariate and part of bivariate analysis which are usually standard steps in credit rating model development.
Metrics are reported for special (if exists) and complete case groups separately.
Report includes:
\itemize{
\item risk.factor: Risk factor name.
\item type: Special case or complete case group.
\item bin: When special case method is \code{together} then bin is the same as type, otherwise
all special cases are reported separately.
\item cnt: Number of observations.
\item pct: Percentage of observations.
\item min: Minimum value.
\item p1, p5, p25, p50, p75, p95, p99: Percentile values.
\item avg: Mean value.
\item avg.se: Standard error of mean.
\item max: Maximum value.
\item neg: Number of negative values.
\item pos: Number of positive values.
\item cnt.outliers: Number of outliers.
Records above and below \code{Q75 + 1.5 * IQR}, where \code{IQR = Q75 - Q25}, where
IQR is interquartile range.
}
}
\examples{
suppressMessages(library(monobinShiny))
data(gcd)
desc.stat(x = gcd$age, y = gcd$qual)
gcd$age[1:10] <- NA
gcd$age[50:75] <- Inf
desc.stat(x = gcd$age, y = gcd$qual, sc.method = "together")
desc.stat(x = gcd$age, y = gcd$qual, sc.method = "separately")

}
