% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ORplot.R
\name{ORplot}
\alias{ORplot}
\title{Plot for odds ratios for a S3 object of glm}
\usage{
ORplot(
  x,
  type = 1,
  xlab = "",
  ylab = "",
  show.OR = TRUE,
  show.CI = FALSE,
  sig.level = 1,
  cex = 1.2,
  lwd = 2,
  pch = 18,
  col = NULL,
  ...
)
}
\arguments{
\item{x}{A S3 object of glm}

\item{type}{an integer defining the shape of plots; default value is 1}

\item{xlab}{label for the horizontal-axis; defaults to "Odds Ratios"}

\item{ylab}{label for the vertical axis; defaults to "".}

\item{show.OR}{A logical value; Whether or not show p values on plot}

\item{show.CI}{A logical value; Whether or not show 95\% CI values on plot}

\item{sig.level}{A numeric value of upper limit of p value of showing variables}

\item{cex}{A numerical value giving the amount by which plotting OR/HR symbols
should be magnified relative to the default, defaulting 1.2.}

\item{lwd}{The line width, a positive number, defaulting to 2.}

\item{pch}{Either an integer specifying a symbol or a single character
to be used as the default in plotting OR/HR points.}

\item{col}{A specification for the default plotting color.}

\item{...}{arguments to be passed to plot}
}
\value{
This function return NULL invisibly and draw graphs
}
\description{
Plot for odds ratios for a S3 object of glm
}
\examples{
require(survival)
data(colon)
out1=glm(status~sex+age+rx+obstruct+node4,data=colon)
out2=glm(status~rx+node4,data=colon)
ORplot(out1,type=2,show.CI=TRUE,xlab="This is xlab",main="Main Title")
ORplot(out2,type=1,main="Main Title")
ORplot(out1,type=2,show.CI=TRUE,main="Main Title")
ORplot(out1,type=3,show.CI=TRUE,main="Main Title",sig.level=0.05)
ORplot(out1,type=3,show.CI=TRUE,main="Main Title",sig.level=0.05,
       pch=1,cex=2,lwd=4,col=c("red","blue"))
}
