% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_group.R
\name{make_groups}
\alias{make_groups}
\alias{make_groups_sub}
\alias{max_sum_str_length}
\title{Make groups by splitting string length}
\usage{
make_groups(
  tbl,
  text_col = "text",
  length = 8000,
  tmp_group = "tmp_group",
  str_length = "str_length"
)

make_groups_sub(tbl, text_col, n_group, tmp_group, str_length)

max_sum_str_length(tbl, tmp_group, str_length)
}
\arguments{
\item{tbl}{A tibble or data.frame.}

\item{text_col}{A text. Colnames for morphological analysis.}

\item{length}{A numeric.}

\item{tmp_group, str_length}{A string to use temporary.}

\item{n_group}{A numeric.}
}
\value{
A tibble.   Output of 'MeCab' and added column "text_id".

A string

A string

A string

A character vector

A character vector

A character vector

A character vector

A character vector

A data.frame
}
\description{
Using 'MeCab' for morphological analysis.
Keep other colnames in dataframe.
}
\examples{
\dontrun{
  library(magrittr)
  data(neko)
  neko <-
      neko \%>\%
      unescape_utf()

  # mecab
  bin_dir <- "d:/pf/mecab/bin"
  iconv <- "CP932_UTF-8"
  neko \%>\%
    moranajp_all(text_col = "text", bin_dir = bin_dir, iconv = iconv) \%>\%
        print(n=100)

  # ginza
  neko \%>\%
    moranajp_all(text_col = "text", method = "ginza") \%>\%
      print(n=100)

  # sudachi
  bin_dir <- "d:/pf/sudachi"
  iconv <- "CP932_UTF-8"
  neko \%>\%
    moranajp_all(text_col = "text", bin_dir = bin_dir, 
                 method = "sudachi_a", iconv = iconv) \%>\%
        print(n=100)

}
}
