% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tokenize.R
\name{.mp_tokenize_word}
\alias{.mp_tokenize_word}
\title{Tokenize a Word}
\usage{
.mp_tokenize_word(
  word,
  vocab_split,
  dir = 1,
  allow_compounds = TRUE,
  unk_token = "[UNK]",
  max_chars = 100
)
}
\arguments{
\item{word}{Word to tokenize.}

\item{vocab_split}{List of named integer vector containing vocabulary words.
Should have components named "prefixes", "words", "suffixes"}

\item{dir}{Integer; if 1 (the default), look for tokens starting at the
beginning of the word. Otherwise, start at the end.}

\item{allow_compounds}{Logical; whether to allow multiple whole words in the
breakdown.}

\item{unk_token}{Token to represent unknown words.}

\item{max_chars}{Maximum length of word recognized.}
}
\value{
Input word as a list of tokens.
}
\description{
Tokenize a single "word" (no whitespace). The word can technically contain
punctuation, but typically punctuation has been split off by this point.
}
\details{
This is an adaptation of wordpiece:::.tokenize_word. The main differences are
that it was designed to work with a morphemepiece vocabulary, which can
include prefixes (denoted like "pre##"). As in wordpiece, the algorithm uses
a repeated greedy search for the largest piece from the vocabulary found
within the word, but starting from either the beginning or the end of the
word (controlled by the \code{dir} parameter). The input vocabulary must be split
into prefixes, suffixes, and "words".
}
\keyword{internal}
