% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ppc.reproFitTT.R
\name{ppc.reproFitTT}
\alias{ppc.reproFitTT}
\title{Posterior predictive check plot for reproFitTT objects}
\usage{
\method{ppc}{reproFitTT}(x, style = "generic", ...)
}
\arguments{
\item{x}{An object of class \code{reproFitTT}}

\item{style}{Graphical package method: \code{generic} or \code{ggplot}.}

\item{\dots}{Further arguments to be passed to generic methods.}
}
\description{
The \code{ppc} function plot the observed versus predicted values for the
\code{reporFitTT} objects.
}
\examples{

# (1) Load the data
data(cadmium1)

# (2) Create an object of class "reproData"
dat <- reproData(cadmium1)

\dontrun{
# (3) Run the reproFitTT function with the log-logistic gamma-poisson model
out <- reproFitTT(dat, stoc.part = "gammapoisson",
ecx = c(5, 10, 15, 20, 30, 50, 80), quiet = TRUE)

# (4) Plot observed versus predicted values
ppc(out)
}

}

