% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.reproData.R
\name{plot.reproData}
\alias{plot.reproData}
\title{Plotting method for \code{reproData} objects}
\usage{
\method{plot}{reproData}(x, xlab, ylab = "Cumulated Number of offspring",
  main = NULL, concentration = NULL, style = "generic",
  pool.replicate = FALSE, addlegend = FALSE, remove.someLabels = FALSE,
  ...)
}
\arguments{
\item{x}{an object of class \code{reproData}}

\item{xlab}{a title for the \eqn{x}-axis (optional)}

\item{ylab}{a title for the \eqn{y}-axis}

\item{main}{main title for the plot}

\item{concentration}{a numeric value corresponding to some concentration in
\code{data}. If \code{concentration = NULL}, draws a plot for each concentration}

\item{style}{graphical backend, can be \code{'generic'} or \code{'ggplot'}}

\item{pool.replicate}{if \code{TRUE}, the datapoints of each replicate are
summed for a same concentration}

\item{addlegend}{if \code{TRUE}, adds a default legend to the plot}

\item{remove.someLabels}{if \code{TRUE}, removes 3/4 of X-axis labels in
\code{'ggplot'} style to avoid the label overlap}

\item{\dots}{Further arguments to be passed to generic methods}
}
\description{
This is the generic \code{plot} S3 method for the \code{reproData} class.
It plots the cumulated number of offspring as a function of time.
}
\note{
When \code{style = "ggplot"}, the function calls function
\code{\link[ggplot2]{ggplot}} and returns an object of class \code{ggplot}
}
\examples{

library(ggplot2)

# (1) Load the data
data(cadmium1)
cadmium1 <- reproData(cadmium1)

# (2) Plot the reproduction data
plot(cadmium1)

# (3) Plot the reproduction data for a fixed concentration
plot(cadmium1, concentration = 4.36, style = "ggplot")

}
\keyword{plot}

