% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.survData.R
\name{plot.survData}
\alias{plot.survData}
\title{Plotting method for \code{survData} objects}
\usage{
\method{plot}{survData}(x, xlab, ylab = "Number of surviving individuals",
  main = NULL, concentration = NULL, style = "generic",
  pool.replicate = FALSE, addlegend = FALSE, remove.someLabels = FALSE,
  ...)
}
\arguments{
\item{x}{an object of class \code{survData}}

\item{xlab}{a title for the \eqn{x}-axis (optional)}

\item{ylab}{a label for the \eqn{y}-axis}

\item{main}{main title for the plot}

\item{concentration}{a numeric value corresponding to some concentration in
\code{data}. If \code{concentration = NULL}, draws a plot for each concentration}

\item{style}{graphical backend, can be \code{'generic'} or \code{'ggplot'}}

\item{pool.replicate}{if \code{TRUE}, the datapoints of each replicate are
summed for a same concentration}

\item{addlegend}{if \code{TRUE}, adds a default legend to the plot}

\item{remove.someLabels}{if \code{TRUE}, removes 3/4 of X-axis labels in
\code{'ggplot'} style to avoid label overlap}

\item{\dots}{Further arguments to be passed to generic methods}
}
\description{
This is the generic \code{plot} S3 method for the \code{survData} class.
It plots the number of survivors as a function of time.
}
\note{
When \code{style = "ggplot"}, the function calls function
\code{\link[ggplot2]{ggplot}} and returns an object of class \code{ggplot}.
}
\examples{

library(ggplot2)

# (1) Load the data
data(zinc)
zinc <- survData(zinc)

# (2) Plot survival data with a ggplot style
plot(zinc, style = "ggplot")

# (3) Plot the survival data for a fixed concentration
plot(zinc, concentration = 0.66, style = "ggplot")

}
\keyword{plot}

