% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/morse.R
\docType{data}
\name{copper}
\alias{copper}
\title{Reproduction and survival datasets for \emph{Daphnia magna} exposed to
copper during 21 days}
\format{A data frame with 240 observations of the following five variables:
\describe{ \item{\code{replicate}}{A vector of class \code{numeric} with the
replicate code (\code{1} to \code{15}).} \item{\code{conc}}{A vector of
class \code{numeric} with the copper concentrations in \eqn{\mu g.L^{-1}}.}
\item{\code{time}}{A vector of class \code{integer} with the time points
(in days from the beginning of the experiment \eqn{t = 0}).}
\item{\code{Nsurv}}{A vector of class \code{integer} with the number of
alive individuals at each time point for each concentration and each
replicate.} \item{\code{Nrepro}}{A vector of class \code{integer} with the
number of offspring at each time point for each concentration and each
replicate.} }}
\usage{
data(copper)
}
\description{
Reproduction and survival datasets of chronic laboratory toxicity tests with
\emph{Daphnia magna} freshwater invertebrate exposed to five concentrations
of copper during 21 days. Five concentrations were
tested, with three replicates per concentration. Each replicate contained 20
organisms. Reproduction and survival were monitored at 16 time points.
}
\references{
Billoir, E., Delignette-Muller, M.L., Pery, A.R.R. and
Charles, S. (2008) A Bayesian Approach to Analyzing Ecotoxicological Data,
\emph{Environmental Science & Technology}, 42 (23), 8978-8984.
}
\keyword{dataset}
