% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.survFit.R
\name{predict.survFit}
\alias{predict.survFit}
\title{Predict method for \code{survFit} objects}
\usage{
\method{predict}{survFit}(object, data_predict = NULL, spaghetti = FALSE,
  mcmc_size = NULL, hb_value = TRUE, ratio_no.NA = 0.95, ...)
}
\arguments{
\item{object}{An object of class \code{survFit}}

\item{data_predict}{A dataframe with three columns \code{time}, \code{conc} and \code{replicate}
used for prediction. If \code{NULL}, prediction is based on \code{x} object of 
class \code{survFit} used for fitting.}

\item{spaghetti}{If \code{TRUE}, return a set of survival curves using
parameters drawn from the posterior distribution.}

\item{mcmc_size}{Can be used to reduce the number of mcmc samples in order to speed up
the computation.}

\item{hb_value}{If \code{TRUE}, the background mortality \code{hb} is taken into account from the posterior.
If \code{FALSE}, parameter \code{hb} is set to 0. The default is \code{TRUE}.}

\item{ratio_no.NA}{A numeric between 0 and 1 standing for the proportion of non-NA values
required to compute quantile. The default is \eqn{0.95}.}

\item{\dots}{Further arguments to be passed to generic methods}
}
\description{
This is the generic \code{predict} S3 method for the \code{survFit} class.
It provides simulation for "SD" or "IT" models under constant or time-variable exposure.
}
\examples{

# (1) Load the survival data
data("propiconazole_pulse_exposure")

# (2) Create an object of class "survData"
dataset <- survData(propiconazole_pulse_exposure)

\dontrun{
# (3) Run the survFit function
out <- survFit(dataset , model_type = "SD")

# (4) Create a new data table for prediction
data_4prediction <- data.frame(time = 1:10,
                               conc = c(0,5,30,30,0,0,5,30,15,0),
                               replicate= rep("predict", 10))

# (5) Predict on a new dataset
predict_out <- predict(object = out, data_predict = data_4prediction, spaghetti = TRUE)

}


}
