% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/morse.R
\docType{data}
\name{dichromate}
\alias{dichromate}
\title{Survival data set for \emph{Daphnia magna} exposed to dichromate
during 21 days}
\format{A data frame with 60 observations on the following four variables:
\describe{ \item{\code{replicate}}{A vector of class \code{numeric} with the
replicate code (\code{1}).} \item{\code{conc}}{A vector of
class \code{numeric} with dichromate concentrations in \eqn{mg.L^{-1}}.}
\item{\code{time}}{A vector of class \code{integer} with the time points
(in days from the beginning of the experiment \eqn{t = 0}).}
\item{\code{Nsurv}}{A vector of class \code{integer} with the number of
alive individuals at each time point for each concentration and each
replicate.}}}
\usage{
data(dichromate)
}
\description{
Survival data set of chronic laboratory toxicity tests with
\emph{Daphnia magna} freshwater invertebrate exposed to six concentrations
of one oxidizing agent (potassium dichromate) during 21 days. Six
concentrations were tested with one replicate of 50 organisms per concentration.
Survival is monitored at 10 time points.
}
\references{
Bedaux, J., Kooijman, SALM (1994) Statistical analysis of toxicity tests,
based on hazard modeling, \emph{Environmental and Ecological Statistics}, 1,
303-314.
}
\keyword{data}
\keyword{set}
