% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_Nsurv_ode.R
\name{predict_Nsurv_ode}
\alias{predict_Nsurv_ode}
\title{Predict method for \code{survFit} objects}
\usage{
predict_Nsurv_ode(
  object,
  data_predict,
  spaghetti,
  mcmc_size,
  hb_value,
  interpolate_length,
  interpolate_method,
  hb_valueFORCED,
  ...
)
}
\arguments{
\item{object}{An object of class \code{survFit}.}

\item{data_predict}{A dataframe with three columns \code{time}, \code{conc} and \code{replicate}
used for prediction. If \code{NULL}, prediction is based on \code{x} object of 
class \code{survFit} used for fitting.}

\item{spaghetti}{If \code{TRUE}, return a set of survival curves using
parameters drawn from the posterior distribution.}

\item{mcmc_size}{Can be used to reduce the number of mcmc samples in order to speed up
the computation. \code{mcmc_size} is the number of selected iterations for one chain. Default
is 1000. If all MCMC is wanted, set argument to \code{NULL}.}

\item{hb_value}{If \code{TRUE}, the background mortality \code{hb} is taken into account from the posterior.
If \code{FALSE}, parameter \code{hb} is set to 0. The default is \code{TRUE}.}

\item{interpolate_length}{Length of the time sequence for which output is wanted.}

\item{interpolate_method}{The interpolation method for concentration. See package \code{deSolve} for details.
Default is \code{linear}.}

\item{hb_valueFORCED}{If \code{hb_value} is \code{FALSE}, it fix \code{hb}.}

\item{\dots}{Further arguments to be passed to generic methods}
}
\description{
This is a \code{method} to replace function \code{predict_Nsurv} used on \code{survFit}
object when computing issues happen. \code{predict_nsurv_ode} uses the \code{deSolve}
library to improve robustness. However, time to compute may be longer.
}
