% Generated by roxygen2 (4.0.2): do not edit by hand
\name{qdist}
\alias{qdist}
\alias{xqchisq}
\alias{xqf}
\alias{xqgamma}
\alias{xqt}
\title{Illustrated quantile calculations from distributions}
\usage{
qdist(dist = "norm", p, plot = TRUE, verbose = FALSE, invisible = FALSE,
  digits = 4, xlim, ylim, vlwd = 2,
  vcol = trellis.par.get("add.line")$col, rot = 45, ...)

xqgamma(...)

xqt(...)

xqchisq(...)

xqf(...)
}
\arguments{
\item{dist}{a character discription of a distribution, for example
\code{"norm"}, \code{"t"}, or \code{"chisq"}}

\item{p}{a vector of probabilities}

\item{plot}{a logical indicating whether a plot should be created}

\item{verbose}{a logical}

\item{invisible}{a logical}

\item{digits}{the number of digits desired}

\item{xlim}{x limits}

\item{ylim}{y limits}

\item{vlwd}{width of vertical lines}

\item{vcol}{color of vertical lines}

\item{rot}{angle for rotating text indicating probability}

\item{...}{additional arguments, including parameters of the distribution
and additional options for the plot}
}
\value{
a vector of quantiles; a plot is printed as a side effect
}
\description{
Illustrated quantile calculations from distributions
}
\details{
The most general function is \code{qdist} which can work with
any distribution for which a q-function exists.  As a convenience, wrappers are
provided for several common distributions.
}
\examples{
qdist("norm", seq(.2, .8, by=.10))
xqnorm(seq(.2, .8, by=.10), mean=100, sd=10)
qdist("unif", .5)
xqgamma(.5, shape=3, scale=4)
xqchisq(c(.25,.5,.75), df=3)
}

