% Generated by roxygen2 (4.0.2): do not edit by hand
\name{swap}
\alias{swap}
\title{Swap values among columns of a data frame}
\usage{
swap(data, which)
}
\arguments{
\item{data}{a data frame}

\item{which}{a formula or an integer or character vector specifying columns in
\code{data}}
}
\description{
Swap values among columns of a data frame
}
\details{
\code{swap} is not a particularly speedy function.  It is intended primarily
as an aid for teaching randomization for paired designs.  Used this way, the number of
randomizations should be kept modest (approximately 1000) unless you are very patient.
}
\examples{
if (require(tidyr)) {
  Sleep2 <- sleep \%>\% spread( key=group, val=extra )
  names(Sleep2) <- c("subject", "drug1", "drug2")
  swap(Sleep2, drug1 ~ drug2)
  mean( ~(drug1 - drug2), data=Sleep2)
  do(3) * mean( ~(drug1 - drug2), data=Sleep2 \%>\% swap(drug1 ~ drug2) )
}
}

