% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/do.R
\docType{methods}
\name{do}
\alias{do}
\alias{do.numeric}
\alias{do.default}
\alias{Do}
\alias{print.repeater}
\alias{*,repeater,ANY-method}
\title{Do Things Repeatedly}
\usage{
do(object, ...)

\method{do}{numeric}(object, ...)

\method{do}{default}(object, ...)

Do(n = 1L, cull = NULL, mode = "default", algorithm = 1,
  parallel = TRUE)

\method{print}{repeater}(x, ...)

\S4method{*}{repeater,ANY}(e1, e2)
}
\arguments{
\item{object}{an object}

\item{...}{additional arguments}

\item{n}{number of times to repeat}

\item{cull}{function for culling output of objects being repeated.  If NULL,
a default culling function is used.  The default culling function is
currently aware of objects of types
\code{lme},
\code{lm},
\code{htest},
\code{table},
\code{cointoss}, and
\code{matrix}.}

\item{mode}{target mode for value returned}

\item{algorithm}{a number usd to select the algorithm used.  Currently numbers below 1
use an older algorithm and numbers >=1 use a newer algorithm which is faster in some
situations.}

\item{parallel}{a logical indicating whether parallel computation should be attempted
using the \pkg{parallel} package (if it is installed and loaded).}

\item{x}{an object created by \code{do}.}

\item{e1}{an object (in cases documented here, the result of running \code{do})}

\item{e2}{an object (in cases documented here, an expression to be repeated)}
}
\value{
\code{do} returns an object of class \code{repeater} which is only useful in
the context of the operator \code{*}.  See the examples.
}
\description{
\code{do()} provides a natural syntax for repetition tuned to assist
with replication and resampling methods.
}
\note{
\code{do} is a thin wrapper around \code{Do} to avoid collision with
\code{\link[dplyr:do]{dplyr::do()}} from the \pkg{dplyr} package.
}
\examples{
do(3) * rnorm(1)
do(3) * "hello"
do(3) * 1:4
do(3) * mean(rnorm(25))
if (require(mosaicData)) {
  do(3) * lm(shuffle(height) ~ sex + mother, Galton)
  do(3) * anova(lm(shuffle(height) ~ sex + mother, Galton))
  do(3) * c(sample.mean = mean(rnorm(25)))
  set.rseed(1234)
  do(3) * tally( ~sex|treat, data=resample(HELPrct))
  set.rseed(1234)  # re-using seed gives same results again
  do(3) * tally( ~sex|treat, data=resample(HELPrct))
}
}
\seealso{
\code{\link[=replicate]{replicate()}}, \code{\link[=set.rseed]{set.rseed()}}
}
\author{
Daniel Kaplan (\email{kaplan@macalaster.edu})
and Randall Pruim (\email{rpruim@calvin.edu})
}
\keyword{iteration}
