% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dpqrdist.R
\name{dpqrdist}
\alias{dpqrdist}
\title{Distribution wrapper}
\usage{
dpqrdist(dist, type = c("d", "p", "q", "r"), ...)
}
\arguments{
\item{dist}{a character discription of a distribution, for example
\code{"norm"}, \code{"t"}, or \code{"chisq"}}

\item{type}{one of \code{"x"}, \code{"p"}, \code{"q"}, or \code{"r"}}

\item{...}{additional arguments passed on to underlying distribution function.
Note that one of \code{d}, \code{p}, \code{q}, or \code{n} must
be a named argument in ...}
}
\description{
Utility function wrapping up the d/p/q/r distribution functions
}
\examples{
# 3 random draws from N(1,2)
dpqrdist("norm", "r", n = 3, mean = 1, sd = 2)
# These should all be the same
dpqrdist("norm", "d", x = 0) == dnorm(x = 0)
dpqrdist("norm", "p", q = 0, mean = 1, sd = 2) == pnorm(q = 0, mean = 1, sd = 2)
dpqrdist("norm", "q", p = 0.5, mean = 1, sd = 2) == qnorm(p = 0.5, mean = 1, sd = 2)

}
