% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confint.R, R/mplot.R
\name{confint}
\alias{confint}
\alias{confint.numeric}
\alias{confint.do.tbl_df}
\alias{confint.do.data.frame}
\alias{confint.data.frame}
\alias{confint.summary.lm}
\title{Confidence interval methods for output of resampling}
\usage{
\method{confint}{numeric}(object, parm, level = 0.95, ...,
  method = "percentile", margin.of.error = "stderr" \%in\% method ==
  "stderr")

\method{confint}{do.tbl_df}(object, parm, level = 0.95, ...,
  method = "percentile", margin.of.error = "stderr" \%in\% method,
  df = NULL)

\method{confint}{do.data.frame}(object, parm, level = 0.95, ...,
  method = "percentile", margin.of.error = "stderr" \%in\% method,
  df = NULL)

\method{confint}{data.frame}(object, parm, level = 0.95, ...)

\method{confint}{summary.lm}(object, parm, level = 0.95, ...)
}
\arguments{
\item{object}{and R object}

\item{parm}{a vector of parameters}

\item{level}{a confidence level}

\item{...}{additional arguments}

\item{method}{a character vector of methods to use for creating confidence
intervals.  Choices are "percentile" (or "quantile") which is the default,
"stderr" (or "se"), "bootstrap-t", and
"reverse" (or "basic"))}

\item{margin.of.error}{if true, report intervals as a center and margin of error.}

\item{df}{degrees for freedom. This is required when \code{object} was produced using
\code{link{do}} when
using the standard error to compute the confidence interval since
typically this information is not recorded in these objects.  The default (\code{Inf})
uses a normal critical value rather than a one derived from a t-distribution.}
}
\value{
When applied to a data frame, returns a data frame giving the
confidence interval for each variable in the data frame using
\code{t.test} or \code{binom.test}, unless the data frame was produced using \code{do}, in which case
it is assumed that each variable contains resampled statistics that serve as an estimated sampling
distribution from which a confidence interval can be computed using either a central proportion
of this distribution or using the standard error as estimated by the standard deviation of the
estimated sampling distribution.  For the standard error method, the user must supply the correct
degrees of freedom for the t distribution since this information is typically not available in
the output of \code{\link[=do]{do()}}.

When applied to a numerical vector, returns a vector.
}
\description{
Methods for \code{confint} to compute confidence intervals
on numerical vectors and numerical components of data frames.
}
\details{
The methods of producing confidence intervals from bootstrap distributions are currently
quite naive.  In particular, when using the standard error, assistance may be required with the
degrees of freedom, and it may not be possible to provide a correct value in all situations.
None of the methods include explicit bias correction.
Let \eqn{q_a} be the \eqn{a} quantile of the bootstrap distribution,
let \eqn{t_a, df} be the \eqn{a} quantile of the t distribution with \eqn{df}
degrees of freedom,
let \eqn{SE_b} be the standard deviation of the bootstrap distribution,
and let \eqn{\hat{\theta}} be the estimate computed from the original data.
Then the confidence intervals with confidence level \eqn{1 - 2a} are
\describe{
\item{quantile}{\eqn{(q_a, q_{1-a}) } }
\item{reverse}{ \eqn{( 2 \hat{\theta} - q_{1-a}, 2\hat{\theta} - q_{a} )}}
\item{stderr}{\eqn{(\hat{\theta} - t_{1-a,df} SE_b, \hat{\theta} + t_{1-a,df} SE_b) }.
When \code{df} is not provided,
at attempt is made to determine an appropriate value, but this should be double checked.
In particular, missing data an lead to unreliable results.
}
The bootstrap-t confidence interval is computed much like the reverse confidence interval
but the bootstrap t distribution is used in place of a theoretical t distribution.
This interval has much better properties than the reverse (or basic) method, which
is here for comparison purposes only and is not recommended.
}
}
\examples{
if (require(mosaicData)) {
  bootstrap <- do(500) * diffmean( age ~ sex, data = resample(HELPrct) )
  confint(bootstrap)
  confint(bootstrap, method = "percentile")
  confint(bootstrap, method = "boot")
  confint(bootstrap, method = "se", df = nrow(HELPrct) - 1)
  confint(bootstrap, margin.of.error = FALSE)
  confint(bootstrap, margin.of.error = TRUE, level = 0.99, 
    method = c("boot", "se", "perc") )
  bootstrap2 <- do(500) * mean( resample(1:10) ) 
  confint(bootstrap2)
}
lm(width ~ length * sex, data = KidsFeet) \%>\%
  summary() \%>\%
  confint()
}
\references{
Tim C. Hesterberg (2015): What Teachers Should Know about the Bootstrap:
Resampling in the Undergraduate Statistics Curriculum,
The American Statistician,
\url{http://dx.doi.org/10.1080/00031305.2015.1089789}.
}
