% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prop.test.R
\name{prop.test}
\alias{prop.test}
\title{Exact and Approximate Tests for Proportions}
\usage{
prop.test(
  x,
  n,
  p = NULL,
  alternative = c("two.sided", "less", "greater"),
  conf.level = 0.95,
  data = NULL,
  success = NULL,
  ...
)
}
\arguments{
\item{x}{count of successes, length 2 vector of success and failure counts, a formula,
or a character, numeric, or factor vector containing raw data.}

\item{n}{sample size (successes + failures) or a data frame
(for the formula interface)}

\item{p}{a vector of probabilities of success.
The length of p must be the same as the number of groups specified by x,
and its elements must be greater than 0 and less than 1.}

\item{alternative}{character string specifying the alternative hypothesis, must be one of
\code{"two.sided"} (default), \code{"greater"} or \code{"less"}. You can specify just the initial letter.
Only used for testing the null that a single proportion equals a given value, or that two proportions
are equal; ignored otherwise.}

\item{conf.level}{confidence level of the returned confidence interval. Must be a single number
between 0 and 1. Only used when testing the null that a single proportion equals a given value,
or that two proportions are equal; ignored otherwise.}

\item{data}{a data frame (if missing, \code{n} may be a data frame)}

\item{success}{level of variable to be considered success.  All other levels are
considered failure.}

\item{...}{additional arguments (often ignored).
When \code{x} is a formula, \code{groups} can be used to compare groups:
\verb{x = ~ var, groups=g} is equivalent to \code{x = var ~ g}. \code{na.rm} can be a logical
or an integer vector of length 1 or 2 to indicate dimension along which NA's are
removed before coputing the test.
See the examples.}
}
\value{
an \code{htest} object
}
\description{
The mosaic \code{prop.test} provides wrapper functions around the function of the same name in \pkg{stats}.
These wrappers provide an extended interface (including formulas).
\code{prop.test} performs an approximate test of a simple null hypothesis about the
probability of success in a Bernoulli or multinomial experiment
from summarized data or from raw data.
}
\details{
\preformatted{				conf.level = 0.95, ...)
}

This is a wrapper around \code{\link[=prop.test]{prop.test()}} to simplify its use
when the raw data are available, in which case
an extended syntax for \code{prop.test} is provided.
}
\note{
When \code{x} is a 0-1 vector, 0 is treated as failure and 1 as success. Similarly,
for a logical vector \code{TRUE} is treated as success and \code{FALSE} as failure.
}
\examples{
# Several ways to get a confidence interval for the proportion of Old Faithful
# eruptions lasting more than 3 minutes.
prop.test( faithful$eruptions > 3 )
prop.test(97,272)
faithful$long <- faithful$eruptions > 3
prop.test( faithful$long )
prop.test( ~long , data = faithful )
prop.test( homeless ~ sex, data = HELPrct )
prop.test( ~ homeless | sex, data = HELPrct )
prop.test( ~ homeless, groups = sex, data = HELPrct )
prop.test(anysub ~ link, data = HELPrct, na.rm = TRUE)
prop.test(link ~ anysub, data = HELPrct, na.rm = 1)
prop.test(link ~ anysub, data = HELPrct, na.rm = TRUE)

}
\seealso{
\code{\link[=binom.test]{binom.test()}}, \code{\link[stats:prop.test]{stats::prop.test()}}
}
\keyword{stats}
