#' Houses in Saratoga County (2006)
#' 
#' Data on houses in Saratoga County, New York, USA in 2006
#' 
#' @docType data
#' @name SaratogaHouses
#' @usage data(SaratogaHouses)
#' @format  A data frame with 1728 observations on the following 16 variables.
#' \itemize{
#' \item{\code{price}}{ price (US dollars)}
#' \item{\code{lotSize}}{ size of lot (acres)}
#' \item{\code{age}}{ age of house (years)}
#' \item{\code{landValue}}{ value of land (US dollars)}
#' \item{\code{livingArea}}{ living are (square feet)}
#' \item{\code{pctCollege}}{ percent of neighborhood that graduated college}
#' \item{\code{bedrooms}}{ number of bedrooms}
#' \item{\code{fireplaces}}{ number of fireplaces}
#' \item{\code{bathrooms}}{ number of bathrooms (half bathrooms have no shower or tub)}
#' \item{\code{rooms}}{ number of rooms}
#' \item{\code{heating}}{ type of heating system}
#' \item{\code{fuel}}{ fuel used for heating}
#' \item{\code{sewer}}{ type of sewer system}
#' \item{\code{waterfront}}{ whether property includes waterfront}
#' \item{\code{newConstruction}}{ whether the property is a new construction}
#' \item{\code{centralAir}}{ whether the house has central air}
#' }
#' @source 
#' Data collected by Candice Corvetti and used in the "Stat 101" case study 
#' "How much is a Fireplace Worth".  
#' See also 
#' <https://www.saratogacountyny.gov/departments/real-property-tax-service-agency/>
NA

  
