% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operators.R
\name{intifyMutator}
\alias{intifyMutator}
\alias{intifyRecombinator}
\title{Turn Continuous-Space Operators into Integer-Space Operators}
\usage{
intifyMutator(operator)

intifyRecombinator(operator)
}
\arguments{
\item{operator}{\verb{[ecr_operator]} \code{\link[ecr:makeOperator]{ecr_operator}} that supports continuous
variables.}
}
\value{
\code{\link[ecr:makeOperator]{ecr_operator}} operator that operates on integers.
}
\description{
The input \code{operator} is wrapped: individuals are fed to it as-is, and
output is rounded. Upper and lower bounds are both shifted by 0.5 down or
up, respectively, to retain a fair distribution.
}
\examples{
library(mlrCPO)

# Create parameter set
ps <- pSS(
numb: numeric[1, 10],
int: integer[0, 5])

# Define mutator
# If Gaussian mutator is applied to integer parameter,
# it does not return an integer
combo.mut <- combine.operators(ps,
numeric = mutGauss,
int = mutGauss)
combo.mut(list(numb = 1.5, int = 3))

# Turn continuous-space operator mutGauss into integer-space operator
mutGaussInt <- intifyMutator(mutGauss)
combo.mut.int <- combine.operators(ps,
numeric = mutGauss,
int = mutGaussInt)
combo.mut.int(list(numb = 1.5, int = 3))

# Turn continuous-space operator recSBX into integer-space operator
recSBXInt <- intifyRecombinator(recSBX)
combo.rec.int <- combine.operators(ps,
numeric = recSBX,
int = recSBXInt)
combo.rec.int(list(list(numb = 1.5, int = 3), list(numb = 3, int = 0)))

}
