% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operators.R
\name{selTournamentMO}
\alias{selTournamentMO}
\title{Multi-Objective k-Tournament Selector}
\usage{
selTournamentMO(
  fitness,
  n.select,
  sorting = "crowding",
  ref.point,
  k = 2,
  return.unique = FALSE
)
}
\arguments{
\item{fitness}{\verb{[matrix]} fitness matrix, one column per individual.}

\item{n.select}{\verb{[integer(1)]} number of individuals to select.}

\item{sorting}{\verb{[character(1)]} one of \code{"domhv"} or \code{"crowding"} (default).}

\item{ref.point}{\verb{[numeric]} reference point for hypervolume, must be given
if \code{sorting} is \code{"domhv"}.}

\item{k}{\verb{[integer(1)]} number of individuals to select at once.}

\item{return.unique}{\verb{[logical(1)]} whether returned individual indices must be unique.}
}
\value{
\verb{[integer]} vector of selected individuals.
}
\description{
k individuals are chosen randomly and the best one
is chosen. This process is repeated \code{n.select} times.

Choice is primarily by dominated sorting
and secondarily by either dominated hypervolume
or crowding distance, depending on \code{sorting}.

Ties are broken randomly by adding random noise of relative magnitude
\code{.Machine$double.eps * 2^10} to points.
}
\seealso{
Other Selectors: 
\code{\link{selSimpleUnique}()}
}
\concept{Selectors}
