% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering.R
\name{run_motif_clustering}
\alias{run_motif_clustering}
\title{Run motif-based clustering}
\usage{
run_motif_clustering(
  adj_mat,
  motif_name,
  motif_type = c("struc", "func"),
  mam_weight_type = c("unweighted", "mean", "product"),
  mam_method = c("sparse", "dense"),
  num_eigs = 2,
  type_lap = c("comb", "rw"),
  restrict = TRUE,
  num_clusts = 2
)
}
\arguments{
\item{adj_mat}{Adjacency matrix to be embedded.}

\item{motif_name}{Motif used for the motif adjacency matrix.}

\item{motif_type}{Type of motif adjacency matrix to use.
One of \code{"func"} or \code{"struc"}.}

\item{mam_weight_type}{Weighting scheme for the motif adjacency matrix.
One of \code{"unweighted"}, \code{"mean"} or \code{"product"}.}

\item{mam_method}{The method to use for building the motif adjacency matrix.
One of \code{"sparse"} or \code{"dense"}.}

\item{num_eigs}{Number of eigenvalues and eigenvectors for the embedding.}

\item{type_lap}{Type of Laplacian for the embedding.
One of \code{"comb"} or \code{"rw"}.}

\item{restrict}{Whether or not to restrict the motif adjacency matrix
to its largest connected component before embedding.}

\item{num_clusts}{The number of clusters to find.}
}
\value{
A list with 8 entries:
\itemize{
  \item \code{adj_mat}: the original adjacency matrix.
  \item \code{motif_adj_mat}: the motif adjacency matrix.
  \item \code{comps}: the indices of the largest connected component
    of the motif adjacency matrix
    (if restrict = TRUE).
  \item \code{adj_mat_comps}: the original adjacency matrix restricted
    to the largest connected component of the motif adjacency matrix
    (if restrict = TRUE).
  \item \code{motif_adj_mat_comps}: the motif adjacency matrix restricted
    to its largest connected component
    (if restrict = TRUE).
  \item \code{vals}: a length-\code{num_eigs} vector containing the
    eigenvalues associated with the Laplace embedding
    of the (restricted) motif adjacency matrix.
  \item \code{vects}: a matrix
    containing the eigenvectors associated with the Laplace embedding
    of the (restricted) motif adjacency matrix.
  \item \code{clusts}: a vector containing integers representing the
    cluster assignment of each vertex in the (restricted) graph.
}
}
\description{
Run motif-based clustering on the adjacency matrix of a
(weighted directed) network,
using a specified motif, motif type, weighting scheme,
embedding dimension, number of clusters and Laplacian type.
}
\examples{
adj_mat <- matrix(c(1:9), nrow = 3)
run_motif_clustering(adj_mat, "M1", "func")
}
