% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import.R
\name{mt_import_wide}
\alias{mt_import_wide}
\title{Import mouse-tracking data saved in wide format.}
\usage{
mt_import_wide(raw_data, xpos_label = "X", ypos_label = "Y",
  timestamps_label = NULL, dist_label = NULL, vel_label = NULL,
  acc_label = NULL, mt_id_label = NULL, pos_sep = "_", pos_ids = NULL,
  reset_timestamps = TRUE)
}
\arguments{
\item{raw_data}{a data.frame containing the raw data.}

\item{xpos_label}{a character string specifying the core of the column labels
containing the x-positions (e.g., "X" for "X_1", "X_2", ...).}

\item{ypos_label}{a character string specifying the core of the column labels
containing the y-positions (e.g., "Y" for "Y_1", "Y_2", ...).}

\item{timestamps_label}{an optional character string specifying the core of
the column labels containing the timestamps.}

\item{dist_label}{an optional character string specifying the core of the
column labels containing the distance traveled.}

\item{vel_label}{an optional character string specifying the core of the
column labels containing the velocity.}

\item{acc_label}{an optional character string specifying the core of the
column labels containing the acceleration.}

\item{mt_id_label}{an optional character string specifying the name of the
column that provides a unique ID for every trial. If unspecified, an ID
variable will be generated.}

\item{pos_sep}{a character string indicating the character that connects the
core label and the position, (e.g., "_" for "X_1", "Y_1", ...).}

\item{pos_ids}{the vector of IDs used for indexing the x-coordinates,
y-coordinates etc. (e.g., 1:101 for time-normalized trajectories from
MouseTracker). If unspecified, column labels for the respective variable
will be extracted using grep (see Details).}

\item{reset_timestamps}{logical indicating if the first timestamp should be
subtracted from all timestamps within a trial. Default is TRUE as it is
recommended for all following analyses in mousetrap.}
}
\value{
A mousetrap data object (see \link{mt_example}).
}
\description{
\code{mt_import_wide} receives a data.frame where mouse-tracking data are
stored in wide format, i.e., where one row contains the data of one trial and
every recorded mouse position is saved in a separate variable. This is, e.g.,
the case when exporting trajectories from MouseTracker (Freeman & Ambady,
2010). From this data.frame, \code{mt_import_wide} creates a mousetrap data
object containing the trajectories and additional data for further processing
within the mousetrap package. \code{mt_import_wide} returns a list, which
includes the trajectory data as an array, and all other data as a data.frame.
This data structure can then be passed on to other functions within this
package, such as \link{mt_time_normalize} or \link{mt_calculate_measures}.
}
\details{
\code{mt_import_wide} is designed to import mouse-tracking data saved in a
wide format. The defaults are set so that usually only the \code{raw_data}
and \code{pos_ids} need to be provided when importing trajectory data that
stem from a "time normalized analysis" in MouseTracker (Freeman & Ambady,
2010).

If no \code{pos_ids} are provided, column labels for the respective variable
(e.g., x-positions) are extracted using \link{grep} returning all variables
that start with the respective character string (e.g. "X" for x-positions).
This is, e.g., useful when importing trajectory data that stem from a "raw
time analysis" in MouseTracker (Freeman & Ambady, 2010).

If no timestamps are provided, \code{mt_import_wide} automatically assumes
equally spaced sampling intervals and creates a timestamp variable with
increasing integers (starting with 0).

If labels for distance, velocity, and acceleration are provided, these are
included in the trajectory array.
}
\examples{
\dontrun{

# Data from "time normalized analysis" in MouseTracker
raw_data <- read_mousetracker("tn_data_exported.csv")
data <- mt_import_wide(raw_data, pos_ids=1:101)

# Data from "raw time analysis" in MouseTracker
raw_data <- read_mousetracker("raw_data_exported.csv", last_lines_to_rm=2*8)
data <- mt_import_wide(raw_data)

}
}
\references{
Freeman, J. B., & Ambady, N. (2010). MouseTracker: Software for
studying real-time mental processing using a computer mouse-tracking method.
\emph{Behavior Research Methods, 42}(1), 226-241.
}
\seealso{
\link{read_mousetracker} for reading data into R that were exported
from MouseTracker (Freeman & Ambady, 2010).

\link{mt_import_mousetrap} and \link{mt_import_long} for importing
mouse-tracking data from other sources.
}

