% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mt_filter_unique.R
\name{mt_filter_unique}
\alias{mt_filter_unique}
\alias{mt_unique}
\title{Filter out duplicated records from a \code{move2} object}
\usage{
mt_filter_unique(x, ...)

mt_unique(
  x,
  criterion = c("subsets", "sample", "first", "last"),
  additional_columns = NULL
)
}
\arguments{
\item{x}{The \code{move2} object to filter}

\item{...}{Arguments passed on to the \code{mt_unique} function}

\item{criterion}{The criterion to decide what records to filter out. For more information see \emph{Details} below.}

\item{additional_columns}{In some cases different sensors or tracking devices
might have the same combination of time and track identifier.
It might, for example, be desirable to retain records from an accelerometer
and gps recorded at the same time.
This argument can be used to indicate additional column to include in the grouping
within which the records should not be duplicated.
See the examples below for its usage.}
}
\value{
\code{mt_unique}returns a logical vector indicating the unique records.\cr
\code{mt_filter_unique} returns a filtered \code{move2} object
}
\description{
\itemize{
\item \code{mt_filter_unique}: returns a \code{move2} from which duplicated records have been removed
\item \code{mt_unique}: returns a logical vector indicating the unique records
By default columns that have a duplicated timestamps and track identifier are filtered
}
}
\details{
To make an informed choice of how to remove duplicates, we recommend to first try to understand why the data set has duplicates.

Several methods for filtering duplicates are available the options can be controlled through the \code{criterion}
argument:
\itemize{
\item \code{"subsets"}: Only records that are a subset of other records are omitted.
Some tracking devices first transmit an smaller dataset that does not contain all information, therefore some
records may be the same as others only containing additional \code{NA} values.
This strategy only omits those (duplicated) records. As a result duplicates that contain unique information are
retained, the dataset is thus not guaranteed to not have unique records afterwards.
\item \code{"sample"}: In this case one record is randomly selected from the duplicated records.
\item \code{"first"}: Select the first location from a set of duplicated locations. Note that reordering the data will affect
which record is selected. For movebank data no specific order is enforced, ensure that the order of the locations is like you expect (same goes for \code{"last"}).
\item \code{"last"}: Select the last location from a set of duplicated locations.
}
}
\examples{
m <- mt_sim_brownian_motion(1:2)[rep(1:4, 4), ]
m$sensor_type <- as.character(gl(2, 4))
m$sensor_type_2 <- as.character(gl(2, 8))
table(mt_unique(m, "sample"))
mt_filter_unique(m[, c("time", "track", "geometry")])
mt_filter_unique(m[, c("time", "track", "geometry", "sensor_type")],
  additional_columns = sensor_type
)
if (requireNamespace("dplyr")) {
  mt_filter_unique(m, additional_columns = across(all_of(c("sensor_type", "sensor_type_2"))))
}
mt_filter_unique(m, "sample")
mt_filter_unique(m, "first")
m$sensor_type[1:12] <- NA
mt_filter_unique(m[, c("time", "track", "geometry", "sensor_type")])
}
\seealso{
Other filter: 
\code{\link{mt_filter_movebank_visible}()},
\code{\link{mt_filter_per_interval}()}
}
\concept{filter}
