% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stateProbs.R
\name{stateProbs}
\alias{stateProbs}
\title{State probabilities}
\usage{
stateProbs(m)
}
\arguments{
\item{m}{A \code{moveHMM} object.}
}
\value{
The matrix of state probabilities, with element [i,j] the probability
of being in state j in observation i.
}
\description{
For a given model, computes the probability of the process being in the different states
at each time point.
}
\examples{
# m is a moveHMM object (as returned by fitHMM), automatically loaded with the package
m <- example$m

sp <- stateProbs(m)

}
\references{
Zucchini, W. and MacDonald, I.L. 2009.
Hidden Markov Models for Time Series: An Introduction Using R.
Chapman & Hall (London).
}

