% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimatePhi.R
\name{estimatePhi}
\alias{estimatePhi}
\title{estimatePhi}
\usage{
estimatePhi(data,
  isThermallingFunction = getDefaultIsThermallingFunction(360, 4),
  maxPointsToUseInEstimate = 20, phiInitialEstimate = 0,
  isGoodPoint = NULL, returnPointsUsedInEstimate = F,
  windowSize = 29, ...)
}
\arguments{
\item{data}{An move object or stack.}

\item{isThermallingFunction}{The thermalling function to use.}

\item{maxPointsToUseInEstimate}{Maximal number of desired windows for phi estimation}

\item{phiInitialEstimate}{Initial phi estimate}

\item{isGoodPoint}{The points to use for phi estimation as logical or numeric, if NULL then findGoodPoints is used.}

\item{returnPointsUsedInEstimate}{an logical value, if the segments used for phi estimation should also be returned.}

\item{windowSize}{An window size, odd number or the start and end of the window relative to the focal point}

\item{...}{extra arguments for getWindSpeedEstimates}
}
\value{
a list with phi and the log likelihood and the number of locations used
}
\description{
An function to estimate phi (the autocorrelation of speed) from data. This is done using iterative calls to the wind speed optimization on a selection of segments.
}
\examples{
data(storks)
estimatePhi(
  storks[[2]],
  windowSize = 19,
  isSamplingRegular = 1,
  isThermallingFunction = getDefaultIsThermallingFunction(360, 4),
  maxPointsToUseInEstimate = 10
)
}
