% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/movenetw.R
\name{movenetw}
\alias{movenetw}
\title{R function for calculating least-cost path network}
\usage{
movenetw(
  dtm = NULL,
  origin,
  studyplot = NULL,
  funct = "t",
  move = 16,
  cogn.slp = FALSE,
  sl.crit = 10,
  W = 70,
  L = 0,
  N = 1,
  V = 1.2,
  z = 9,
  lcp.dens = FALSE,
  transp = 0.5,
  oneplot = TRUE,
  export = FALSE
)
}
\arguments{
\item{dtm}{Digital Terrain Model (RasterLayer class); if not provided, elevation data will be acquired online for the area enclosed by the 'studyplot' parameter (see \code{\link{movecost}}).}

\item{origin}{location(s) around which the boundary(ies) is calculated (SpatialPointsDataFrame class).}

\item{studyplot}{polygon (SpatialPolygonDataFrame class) representing the study area for which online elevation data are aquired (see \code{\link{movecost}}); NULL is default.}

\item{funct}{cost function to be used (for details on each of the following, see \code{\link{movecost}}):\cr
\strong{-functions expressing cost as walking time-}\cr
\strong{t} (default) uses the on-path Tobler's hiking function;\cr
\strong{tofp} uses the off-path Tobler's hiking function;\cr
\strong{mp} uses the Marquez-Perez et al.'s modified Tobler's function;\cr
\strong{icmonp} uses the Irmischer-Clarke's hiking function (male, on-path);\cr
\strong{icmoffp} uses the Irmischer-Clarke's hiking function (male, off-path);\cr
\strong{icfonp} uses the Irmischer-Clarke's hiking function (female, on-path);\cr
\strong{icfoffp} uses the Irmischer-Clarke's hiking function (female, off-path);\cr
\strong{ug} uses the Uriarte Gonzalez's walking-time cost function;\cr
\strong{ma} uses the Marin Arroyo's walking-time cost function;\cr
\strong{alb} uses the Alberti's Tobler hiking function modified for pastoral foraging excursions;\cr
\strong{gkrs} uses the Garmy, Kaddouri, Rozenblat, and Schneider's hiking function;\cr
\strong{r} uses the Rees' hiking function;\cr
\strong{ks} uses the Kondo-Seino's hiking function;\cr

\strong{-functions for wheeled-vehicles-}\cr
\strong{wcs} uses the wheeled-vehicle critical slope cost function;\cr

\strong{-functions expressing abstract cost-}\cr
\strong{ree} uses the relative energetic expenditure cost function;\cr
\strong{b} uses the Bellavia's cost function;\cr

\strong{-functions expressing cost as metabolic energy expenditure-}\cr
\strong{p} uses the Pandolf et al.'s metabolic energy expenditure cost function;\cr
\strong{pcf} uses the Pandolf et al.'s cost function with correction factor for downhill movements;\cr
\strong{m} uses the Minetti et al.'s metabolic energy expenditure cost function;\cr
\strong{hrz} uses the Herzog's metabolic energy expenditure cost function;\cr
\strong{vl} uses the Van Leusen's metabolic energy expenditure cost function;\cr
\strong{ls} uses the Llobera-Sluckin's metabolic energy expenditure cost function;\cr
\strong{a} uses the Ardigo et al.'s metabolic energy expenditure cost function (for all the mentioned cost functions, see Details);\cr}

\item{move}{number of directions in which cells are connected: 4 (rook's case), 8 (queen's case), 16 (knight and one-cell queen moves; default).}

\item{cogn.slp}{TRUE or FALSE (default) if the user wants or does not want the 'cognitive slope' to be used in place of the real slope (see \code{\link{movecost}}).}

\item{sl.crit}{critical slope (in percent), typically in the range 8-16 (10 by default) (used by the wheeled-vehicle cost function; see \code{\link{movecost}}).}

\item{W}{walker's body weight (in Kg; 70 by default; used by the Pandolf's and Van Leusen's cost function; see \code{\link{movecost}}).}

\item{L}{carried load weight (in Kg; 0 by default; used by the Pandolf's and Van Leusen's cost function; see \code{\link{movecost}}).}

\item{N}{coefficient representing ease of movement (1 by default) (see \code{\link{movecost}}).}

\item{V}{speed in m/s (1.2 by default) (used by the Pandolf et al.'s, Pandolf et al.s with correction factor, Van Leusen's, and Ardigo et al.'s cost function; if set to 0, it is internally worked out on the basis of Tobler on-path hiking function (see \code{\link{movecost}}).}

\item{z}{zoom level for the elevation data downloaded from online sources (from 0 to 15; 9 by default) (see \code{\link{movecost}} and \code{\link[elevatr]{get_elev_raster}}).}

\item{lcp.dens}{TRUE or FALSE (default) if the user wants or does not want the least-cost paths density raster to be produced.}

\item{transp}{set the transparency of the hillshade raster that is plotted over the DTM (0.5 by default).}

\item{oneplot}{TRUE (default) or FALSE if the user wants or does not want the plots displayed in a single window.}

\item{export}{TRUE or FALSE (default) if the user wants or does not want the LCPs network to be exported as a shapefile, and the LCPs network density as a raster; the DTM is exported only if it was not provided by the user
and downloaded by the function from online sources.}
}
\value{
The function returns a list storing the following components \itemize{
 \item{dtm: }{Digital Terrain Model ('RasterLayer' class); returned only if aquired online}
 \item{LCPs.netw: }{list containing the LCPs ('SpatialLinesDataFrame' class) split by origin}
 \item{LCPs.netw.merged: }{'SpatialLinesDataFrame' corresponding to the merged LCPs}
 \item{LCPs.density.count: }{raster ('RasterLayer' class) representing the counts of LCPs on each raster's cell}
 \item{LCPs.density.perc: }{same as the preceding, but re-expressing the counts as percentages)}
}
}
\description{
The function provides the facility to calculate LCPs between multiple origins. The result is a network of LCPs connecting
each origin location to all the others locations. Optionally, a raster representing the density of the LCPs network can be produced.
}
\details{
Like 'movecost()', the function just requires an input DTM ('RasterLayer' class) and an origin dataset  ('SpatialPointsDataFrame' class).
If a DTM is not provided, 'movenetw()' downloads elevation data from online sources for the area enclosed by the polygon fed via
the 'studyplot' parameter (see \code{\link{movecost}} for more details). Under the hood, movenetw()' relies on 'movecost()' and implements the same cost functions:
see the help documentation of 'movecost()' for further information.\cr

'movenetw()' produces a plot representing the input DTM overlaid by an hillshade raster, whose transparency can be adjusted using
the 'transp' parameter. On the rendered plot, the LPCs network ('SpatialLinesDataFrame' class) is represented by black lines. Optionally,
by setting the parameter 'lcp.dens' to TRUE, the function produces a raster representing the density of LCPs. The raster, rendered
overlaid to an hillshade visualization, expresses the density of LCPs as percentages. The percentages are calculated in relation to the
maximum number of LCPs passing through the same cell stored in the raster. A density raster expressing counts is NOT rendered BUT is returned by the function.
The density raster retains the cell size and coordinate system of the input DTM.\cr

The function returns a list storing the DTM (only in case this has not been fed into the function but aquired online), a list of LCPs
split by origin, a SpatialLineDataFrame representing the merged LCPs, and two rasters representing the LCPs network density
expressed as counts and percentages respectively.

The mentioned data can be exported by setting the 'export' parameter to TRUE. The LCPs network and the density raster will
bear a suffix indicating the used cost function.\cr
}
\examples{
# load a sample Digital Terrain Model
volc <- raster::raster(system.file("external/maungawhau.grd", package="gdistance"))


# load the sample destination locations on the above DTM
data(destin.loc)


# calculate the least-cost path network using the Tobler's hiking
# function (for on-path walking)

result <- movenetw(dtm=volc, origin=destin.loc[c(1,2,4),], move=8, funct="t")


}
\seealso{
\code{\link{movecost}}
}
\keyword{movenetw}
