% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wavelet.R
\name{plot_sel_phases}
\alias{plot_sel_phases}
\title{Comparison plot of phases of a coherency object}
\usage{
plot_sel_phases(
  obj,
  view,
  sel.period = NULL,
  sel.upper = NULL,
  sel.lower = NULL,
  ...
)
}
\arguments{
\item{obj}{coherency object.}

\item{view}{View object.}

\item{sel.period}{a single number which determines the (closest available) Fourier period to be selected. Default: NULL.}

\item{sel.upper}{a number to define an upper Fourier period (or the closest available)
for the selection of a band of periods (effective if sel.period is NULL). Default: NULL.}

\item{sel.lower}{a number to define a lower Fourier period (or the closest available)
for the selection of a band of periods (effective if sel.period is NULL). Default: NULL.}

\item{...}{passed to \code{\link[WaveletComp:wc.sel.phases]{WaveletComp::wc.sel.phases()}}.}
}
\value{
an object of class \code{sel.phases}.
}
\description{
Comparison plot of phases of a coherency object
}
\examples{
r <- get_sample_recording()
rv <- get_raw_view(r, "Central", "", "Sitar")
pv <- get_processed_view(rv)
co <- analyze_coherency(pv, columns = c("Nose_x", "Nose_y"))
plot_cross_spectrum(co, pv)
plot_sel_phases(co, pv, sel.period = 0.64)
plot_sel_phases(co, pv, sel.lower = 0.6, sel.upper = 0.8)
}
\seealso{
Other wavelet functions: 
\code{\link{analyze_coherency}()},
\code{\link{analyze_wavelet}()},
\code{\link{get_local_max_average_power}()},
\code{\link{plot_average_coherency}()},
\code{\link{plot_average_power}()},
\code{\link{plot_cross_spectrum}()},
\code{\link{plot_cwt_energy}()},
\code{\link{plot_phase_difference}()},
\code{\link{plot_power_spectrum}()},
\code{\link{plot_roll_resultant_length}()},
\code{\link{plot_wt_energy}()}
}
\concept{wavelet functions}
