% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/listCodingErrors.R
\name{listCodingErrorsInfiniteSelfing}
\alias{listCodingErrorsInfiniteSelfing}
\title{Generate a list of encoding errors assuming infinite selfing}
\usage{
listCodingErrorsInfiniteSelfing(founders, finals)
}
\arguments{
\item{founders}{Genetic data for the founding lines of the population}

\item{finals}{Genetic data for the final lines of the population}
}
\value{
List with the following entries:
	\describe{
		\item{finals}{Markers with an invalid observed value.}
	\item{null}{Markers with a missing value for a founding line, for which the are observations for at least one genetic line.}
		\item{missingHetData}{Markers for which a homozygote did not have an encoding.}
	\item{invalidHetData}{Markers for which the heterozygote encoding data was invalid.}
}
}
\description{
Generate a list of encoding errors assuming infinite selfing
}
\details{
Generate a list of encoding errors assuming infinite selfing. Given the infinite selfing assumption, no information about heterozygote encoding is required.
}
