% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getAllFunnels.R
\name{getAllFunnels}
\alias{getAllFunnels}
\title{Get funnels}
\usage{
getAllFunnels(cross, standardised = FALSE)
}
\arguments{
\item{cross}{The object of class \code{mpcross} containing the pedigree of interest}

\item{standardised}{Should the output funnels be standardised?}
}
\value{
An integer matrix with rows representing genetic lines, and columns representing positions within the funnel.
}
\description{
Get the order of the founding lines, as they contribute to each line in the final population
}
\details{
In multi-parent experimental designs, the founding lines of the population are combined together through initial mixing generations. For experiments without further intercrossing generations, the order in which these mixing crosses occur influences the genotypes of the final lines. It can be important to examine or visualise these orders, which are known as funnels. 

This function returns a matrix, where each row corresponds to a genetic line in the final population, and each column corresponds to a position in the mixing step. So if a row of the returned matrix contains the values 4, 1, 2, 3, then the pedigee that generated the first individual in the experiment started by crossing founders 4 and 1 to give individual 41, and 2 and 3 to give individual 23. Then individuals 41 and 23 are crossed to generate individual 4123, which after inbreeding results in the first final genetic line. 

If sex is considered to be unimportant, then many orderings are equivalent. For example, the ordering 4, 1, 2, 3 of the initial founders is equivalent to 1, 4, 2, 3. In this case each funnel can be put into a standardised ordering, by setting \code{standardised} to \code{FALSE}. 

Note that if there are generations of random interbreeding in the population (often referred to as maintenance generations), then there is no "funnel" associated with a genetic line, and values of NA are returned. In that case, see \code{\link{getAllFunnelsIncAIC}}.  

Note that funnels for all pedigrees simulated by mpMap2 are already standardised. This will not generally be the case for realy experiments.
}
\examples{
data(simulatedFourParentData)
#Funnels used to generate the first ten lines
#Because this is simulated data, they are already standardised, 
#' with the first founder in the first position in the mixing step. 
getAllFunnels(simulatedFourParentData)[1:10, ]
}
