% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/orderCross.R
\name{clusterOrderCross}
\alias{clusterOrderCross}
\title{Group markers into blocks and arrange those blocks}
\usage{
clusterOrderCross(
  mpcrossLG,
  cool = 0.5,
  tmin = 0.1,
  nReps = 1,
  maxMove = 0,
  effortMultiplier = 1,
  randomStart = TRUE,
  nGroups
)
}
\arguments{
\item{mpcrossLG}{An object of class \code{mpcrossLG}, containing genetic data and linkage groups.}

\item{cool}{Rate of cooling}

\item{tmin}{Minimum temperature}

\item{nReps}{Number of independent replications of the simulated annealing algorithm}

\item{maxMove}{Maximum number of positions by which to shift a single marker, as part of the simulated annealing. A value of zero indicates no limit.}

\item{effortMultiplier}{Multiplier for the amount of computational effort}

\item{randomStart}{If TRUE, start from the current ordering}

\item{nGroups}{The number of groups to form using hierarchical clustering}
}
\value{
An object of class \code{mpcrossLG}, identical to the input except with the markers rearranged.
}
\description{
Group markers into blocks and arrange those blocks
}
\details{
In some cases the number of markers is too large to reorder all markers on a chromosome. However, the problem becomes more tractable if the markers are already in a roughly correct ordering to start with. This function is intended to generate that roughly accurate ordering, and then subsequenty local reordering using \code{\link{orderCross}} can be applied to generate a final marker ordering. 

The rough ordering is generated by forming some number of groups of markers, using hierarchical clustering. A consensus disimilarity between every group of markers is formed, and this is used to order the groups. That is, we decide whether the markers will be ordered as group 1, group 2, group 3, etc, or group 2, group 1, group 3, etc. The ordering of the markers within each group is unchanged.
}
