% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/location_functions.R
\name{haversine}
\alias{haversine}
\title{Calculate the Great-Circle Distance between two points in kilometers}
\usage{
haversine(lat1, lon1, lat2, lon2, r = 6371)
}
\arguments{
\item{lat1}{The latitude of point 1 in degrees.}

\item{lon1}{The longitude of point 1 in degrees.}

\item{lat2}{The latitude of point 2 in degrees.}

\item{lon2}{The longitude of point 2 in degrees.}

\item{r}{The average earth radius.}
}
\value{
A numeric value of the distance between point 1 and 2 in kilometers.
}
\description{
Calculate the great-circle distance between two points using the Haversine function.
}
\examples{
fra <- c(50.03333, 8.570556) # Frankfurt Airport
ord <- c(41.97861, -87.90472) # Chicago O'Hare International Airport
haversine(fra[1], fra[2], ord[1], ord[2]) # 6971.059 km
}
