% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sensor_functions.R
\name{first_date}
\alias{first_date}
\title{Extract the date of the first entry}
\usage{
first_date(db, sensor, participant_id = NULL)
}
\arguments{
\item{db}{A database connection to an m-Path Sense database.}

\item{sensor}{The name of a sensor. See \link[mpathsenser]{sensors} for a list of available
sensors.}

\item{participant_id}{A character string identifying a single participant. Use
\code{\link[mpathsenser]{get_participants}} to retrieve all participants from the database.
Leave empty to get data for all participants.}
}
\value{
A string in the format 'YYYY-mm-dd' of the first entry date.
}
\description{
A helper function for extracting the first date of entry of (of one or all participant) of one
sensor. Note that this function is specific to the first date of a sensor. After all, it
wouldn't make sense to extract the first date for a participant of the accelerometer, while the
first device measurement occurred a day later.
}
\examples{
\dontrun{
db <- open_db()
first_date(db, 'Accelerometer', '12345')
}
}
