\name{mpolyAdd}
\alias{+.mpoly}
\alias{mpolyAdd}
\title{Add multivariate polynomials.}
\usage{
\method{+}{mpoly}(e1, e2)
}
\arguments{
  \item{e1}{an object of class mpoly}

  \item{e2}{an object of class mpoly}
}
\value{
object of class mpoly
}
\description{
Compute the sum of two multivariate polynomials.
}
\examples{
list <- list(
  c(x = 1, coef = 1, y = 0),
  c(x = 0, y = 1, coef = 2),
  c(y = 1, coef = -6),
  c(z = 1, coef = -3, x = 2),
  c(x = 1, coef = 0, x = 3),
  c(t = 1, coef = 4, t = 2, y = 4),
  c(coef = 5),
  c(coef = -6)
)

p <- mpoly(list)
p + p

list <- list(c(coef = 1))
( p1 <- mpoly(list) )
list <- list(c(coef = -1))
( p2 <- mpoly(list) )
p1 + p2
}

