% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/components.R
\name{components}
\alias{components}
\alias{[.mpoly}
\alias{LT}
\alias{LC}
\alias{LM}
\alias{multideg}
\alias{totaldeg}
\alias{monomials}
\alias{exponents}
\title{Polynomial components}
\usage{
\method{[}{mpoly}(x, ndx)

LT(x, varorder = vars(x), order = "lex")

LC(x, varorder = vars(x), order = "lex")

LM(x, varorder = vars(x), order = "lex")

multideg(x, varorder = vars(x), order = "lex")

totaldeg(x)

monomials(x)

exponents(x, reduced = FALSE)
}
\arguments{
\item{x}{an object of class mpoly}

\item{ndx}{a subsetting index}

\item{varorder}{the order of the variables}

\item{order}{a total order used to order the terms}

\item{reduced}{if TRUE, don't include zero degrees}

\item{...}{additional arguments}
}
\value{
An object of class mpoly or mpolyList, depending on the
  context
}
\description{
Compute quantities/expressions related to a multivariate 
polynomial.
}
\examples{
(p <- mp("x y^2 + x (x+1) (x+2) x z + 3 x^10"))
p[2]
p[-2]
p[2:3]

LT(p)
LC(p)
LM(p)

multideg(p)
totaldeg(p)
monomials(p)

exponents(p)
exponents(p, reduce = TRUE)
lapply(exponents(p), is.integer)

homogeneous_components(p)

}
