% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_MC_stacked_barplot.R
\name{plot_MC_stacked_barplot}
\alias{plot_MC_stacked_barplot}
\title{Summary Barplot - Missed Cleavages}
\usage{
plot_MC_stacked_barplot(input_list, label = c("absolute", "percentage"))
}
\arguments{
\item{input_list}{A list with data frames and respective information about missed cleavages.}

\item{label}{Character string. Choose between "absolute" or "percentage". Default is "absolute".}
}
\value{
This function returns a stacked barplot.
}
\description{
Plot number of missed cleavages as stacked barplot.
}
\details{
The analyses are summarized in a stacked barplot displaying information about the number of missed cleavages.
}
\examples{
# Load libraries
library(dplyr)
library(tibble)

# Example data
data <- list(
 "A" = tibble::tibble(
   Analysis = c("A", "A", "A", "A", "A"),
   Missed.Cleavage = c("0", "1", "2", "3", "No R/K cleavage site"),
   mc_count = c("2513", "368", "23", "38", "10")
 ),
 "B" = tibble::tibble(
   Analysis = c("B", "B", "B", "B", "B"),
   Missed.Cleavage = c("0", "1", "2", "3", "No R/K cleavage site"),
   mc_count = c("2300", "368", "23", "38", "10")
 )
)

# Plot
plot_MC_stacked_barplot(
  input_list = data,
  label = "absolute"
)
}
\author{
Oliver Kardell
}
